#!/usr/bin/perl

use my_inc "../..";

use strict;
use warnings;
use utf8;

# $Id$

=head1 METADATA

<crontab>
    time: 0 4 * * *
    package: conf-dev
</crontab>

=head1 NAME

bem-clean-cache.pl - очистка кэша сборки bem

=head1 SYNOPSIS

 bem-clean-cache.pl
 bem-clean-cache.pl --cache user

=head1 DESCRIPTION

Скрипт удаляет старые файлы из указанного каталога с кэшом. Старыми считаются файлы, модифицированные
больше недели назад.

Поддерживаемые аргументы командной строки:

    --help
    --usage

    --cache { global | user | none | <directory> }
        Задать каталог для сохранения кэша; значение none поддерживается для совместимости --
        если оно указано, скрипт успешно завершается без выполнения каких-то действий.

=cut

use Cwd;
use FindBin;
use Getopt::Long;

use Yandex::Shell;

my $log;

=head1 SUBROUTINES/METHODS

=head2 run

=cut

sub run {
    my $opt_cache;
    Getopt::Long::GetOptions(
        'cache=s'    => \$opt_cache,
        'help|usage' => \&BemMakeTools::usage,
    ) or die "Invalid options, please refer to --help for usage information.\n";

    $opt_cache ||= 'global';

    return 0 if $opt_cache eq 'none';

    my $rootdir = Cwd::realpath("$FindBin::Bin/../..");

    my @cmd_params = (
        '--rootdir'  => $rootdir,
        '--conffile' => "$rootdir/etc/bem-builder.conf",
        '--cache'    => $opt_cache,
    );

    my $log_root = "$rootdir/protected/logs";
    if ( -d $log_root ) {
        push @cmd_params, '--logdir' => $log_root;
    }

    yash_system(
        '/usr/local/bin/bem-builder',
        @cmd_params,
        'clean_cache',
    );
}

my $result = run();
exit $result;
