#!/usr/bin/perl

=head1

Сравнение скорости автоброкера (calc_price):
perl-ового (AutoBroker::calc_price)
и 
js-ного (calcPrice) при вызове из perl-а

Думаем о том, чтобы объединить их и везде использовать только js-ный.

$data -- залогированные параметры из calc_price при каком-то запросе из интерфейса + добавленные поля для совместимости с js-ным кодом


Результат:

           Rate perl-js    perl
perl-js  8489/s      --    -62%
perl    22075/s    160%      --


sort -R protected/logs/calc_price_params.log |head -n 100|sed 's/.*\s//' |head -n 20 > protected/maintenance/benchmark_calc_price.data


дифф для записи лога calc_price_params.log 

Index: protected/AutoBroker.pm
===================================================================
--- protected/AutoBroker.pm     (revision 89486)
+++ protected/AutoBroker.pm     (working copy)
@@ -13,6 +13,8 @@
 use strict;
 use warnings;
 
+use feature qw/state/;
+
 use List::Util qw/max min/;
 use Clone qw/clone/;
 
@@ -68,6 +70,10 @@
 
 sub calc_price {
     my ($data) = @_;
+    if( $Settings::CONFIGURATION eq 'devtest' ){
+        state $l = new Yandex::Log(log_file_name => 'calc_price_params.log');
+        $l->out($data);
+    }
     my $profile = Yandex::Trace::new_profile('autobroker:calc_price');
 
     # задан коэффициент временного таргетинга



=cut

use strict;
use warnings;

use my_inc "../..";

use Benchmark;
use Path::Tiny;
use JSON;

use Settings;
use Yandex::ExecuteJS;
use Yandex::HTTP;
use AutoBroker;

my $N = $ARGV[0] || 100;
my $LOCAL_JS_SERVER = "http://127.0.0.9:10001/execute";

my @jsons = path("$Settings::ROOT/protected/maintenance/benchmark_calc_price.data")->lines_utf8;

my @data = map {from_json($_)} @jsons;
for my $d ( @data ){
    $d->{strategy} = undef unless exists $d->{strategy};
    $d->{larr} //= '';
}

sub calcPrice_js 
{
    my @broker;
    for my $d (@data){
        my $br = call_js($Settings::ROOT.'/protected/maintenance/calcPrice-debug.js', "calcPrice", 
            [$d,]
        );
        die unless defined $br;
        push @broker, $br;
    }
    return @broker;
}

sub calcPrice_js_standalone
{
    my @broker;
    for my $d (@data){
        my $resp = submit_form('GET', $LOCAL_JS_SERVER, {
                script => "protected/maintenance/calcPrice-debug.js", 
                function => "calcPrice",
                params => encode_json([$d]),
            });
        die $resp->status_line unless $resp->is_success();
        push @broker, $resp->content;
    }
    return @broker;
}


sub calc_price_perl
{
    my @broker;
    for my $d (@data){
        my $br = AutoBroker::calc_price($d);
        push @broker, $br;
    }
    return @broker;
}

# use Data::Dumper; print Dumper(calcPrice_js());
# use Data::Dumper; print Dumper(calc_price_perl());
# use Data::Dumper; print Dumper(calcPrice_js_standalone());
#die;

print "rounds:        $N\nsize of \@data: ".(scalar @data)."\njs server:     $LOCAL_JS_SERVER\n\n";
 
Benchmark::cmpthese($N, {
        perl       => \&calc_price_perl,
        'perl-js'  => \&calcPrice_js,
        'http-js'  => \&calcPrice_js_standalone,
    });

