#!/usr/bin/perl

use my_inc '../..';

use warnings;
use strict;
use utf8;

use Yandex::DBTools;
use Yandex::ListUtils;
use Yandex::Retry;

use Settings;
use ShardingTools;
use ScriptHelper;

my $SLEEP_COEF = 1;

$log->out('START');

$log->out('Reading ret_ids');
my $ids_file = shift @ARGV || die "no file given";
open(my $fh, "<", $ids_file) or $log->die("can't open file $ids_file");

my @ids = <$fh>;
chomp @ids;
$log->out('Got ' . scalar(@ids) . ' ret_ids');

my @shards = @ARGV ? @ARGV : ppc_shards();

for my $shard (@shards) {
    $log->out("Start shard $shard");

    for my $chunk (chunks(\@ids, 1000)) {
        relaxed times => $SLEEP_COEF, sub {
            $log->out('Fixing ret_ids:', $chunk);
            my $updated_rows_cnt = do_sql(PPC(shard => $shard), ['
                    UPDATE bids_retargeting br
                    SET br.statusBsSynced = "No"
                    ', WHERE => {
                        'br.statusBsSynced' => 'Yes',
                        'br.ret_id' => $chunk,
                    },
                ]);
            $log->out("Updated $updated_rows_cnt rows");
        };
    }

    $log->out("Done shard $shard");
}

$log->out('FINISH');

