#!/usr/bin/perl

use my_inc "../..";


=head1 NAME

    bsrank-proxy.pl
    Прокси для подмены вывода bsrank при тестировании

=head1 SYNOPSIS

    bsrank-proxy.pl [--port=50000] [--bsrank-host=bs.yandex.ru]

=cut

use strict;
use warnings;

use HTTP::Response;

use POE;
use POE::Component::Server::TCP;
use POE::Component::Client::HTTP;
use POE::Filter::HTTPD;

use Yandex::ListUtils;

use Settings;
use ScriptHelper get_file_lock => undef;
use Fake;

my $PORT = 50000;
my $BSRANK_HOST = 'bs.yandex.ru';

extract_script_params(
    'port=i' => \$PORT,
    'bsrank-host=s' => \$BSRANK_HOST,
);

$SIG{PIPE} = 'IGNORE';

POE::Component::Client::HTTP->spawn(
    Timeout => 20,
    Alias   => 'ua',
    );

POE::Component::Server::TCP->new(
    Alias        => "web_server",
    Port         => $PORT,
    ClientFilter => 'POE::Filter::HTTPD',
    ClientInput  => \&handle_http_request,
    InlineStates => {got_response => \&handle_http_response,},
    );

POE::Kernel->run();
exit 0;

# вызывается, когда пиходит запрос
sub handle_http_request {
    my ($kernel, $heap, $request) = @_[KERNEL, HEAP, ARG0];

    # If the request is really a HTTP::Response, then it indicates a
    # problem parsing the client's request.  Send the response back so
    # the client knows what's happened.
    if ($request->isa("HTTP::Response")) {
        $heap->{client}->put($request);
        $kernel->yield("shutdown");
        return;
    }

    $request->uri('http://'.$BSRANK_HOST.$request->uri->as_string);

    $request->remove_header("Keep-Alive");
    $request->header("Connection",       "close");
    $request->header("Proxy-Connection", "close");

    # посылаем запрос в bsrank
    $kernel->post("ua" => "request", "got_response", $request);
}

# вызывается, когда приходит ответ от bsrank
sub handle_http_response {
    my ($kernel, $heap) = @_[KERNEL, HEAP];
    my $http_response = $_[ARG1]->[0];
    my $response_type = $http_response->content_type();

    modify_content($http_response);

    # Avoid sending the response if the client has gone away.
    $heap->{client}->put($http_response) if defined $heap->{client};

    # Shut down the client's connection when the response is sent.
    $kernel->yield("shutdown");
}

# творчески дорабатываем ответ сервера
sub modify_content {
    my $resp = shift;
    my $cont = $resp->content;
    my @lines = map {[split /,/]} split /\n/, $cont;
    # индексы начал пачек
    my @series = @{range(0, scalar(@lines), 7)};
    my @ids = grep {$_} map {$lines[$_][3]} @series;
    if (@ids) {
        my $mass_fake_data = get_mass_fake_data(type => ['context_stop_flag', 'phrase_rank'], id => \@ids);
        for my $i (@series) {
            my $fake_data = $mass_fake_data->{$lines[$i][3]} || {};
            # context_stop_flag
            $lines[$i][6] = $fake_data->{context_stop_flag} if exists $fake_data->{context_stop_flag};
            # rank
            $lines[$i+1][0] = $fake_data->{phrase_rank} if exists $fake_data->{phrase_rank};
        }
    }
    $resp->content(join "\n", map {join ",", @$_} @lines);
    $resp->header('Content-Length' => length($resp->content));
    print $resp->content;
}
