// для protected/maintenance/benchmark_calc_price.pl
// по сравнению с кодом из data2 есть модификации, 
// использовать для вызова из кода Диркета НЕЛЬЗЯ
function  calcPrice(data) {
                var currency = data.currency,
                    MIN_PRICE = 0.3, //u.currencies.getConst(currency, 'MIN_PRICE'),
                    PRICE_PLACES = {
        "PREMIUM3" : 12,
        "ROTATION" : 0,
        "GARANT" : 1,
        "GUARANTEE4" : 23,
        "GUARANTEE2" : 21,
        "PREMIUM2" : 11,
        "PREMIUM1" : 10,
        "FIRST" : 2,
        "PREMIUM" : 3,
        "GUARANTEE1" : 20,
        "GUARANTEE3" : 22
    },
                    larrParts = data.larr.split('|'),
                    price = data.price,
                    // значения bid_price amnesty_price в массивах premium и guarantee приходят в виде val * 1e6
                    // для точности вычислений
                    premium = data.premium.map(function(item) {
                        return {
                            bid_price: +item.bid_price,
                            amnesty_price: +item.amnesty_price
                        };
                    }),
                    guarantee = data.guarantee.map(function(item) {
                        return {
                            bid_price: +item.bid_price,
                            amnesty_price: +item.amnesty_price
                        };
                    }),
                    bottom = larrParts[0].split(',').reduce(function(obj, larr) {
                        var parts = larr.split(':'),
                            index = obj.prices.length;

                        parts[1] && (obj.probs[index] = +parts[1]);

                        obj.prices[index] = +parts[0];

                        return obj;
                    }, { prices: [], probs: [] }),
                    minPrice = Math.floor(1e6 * (data.min_price || 0) + 0.5),
                    campRest = Math.floor(1e6 * (data.camp_rest || 0) + 0.5),
                    dayBudget = Math.floor(1e6 * data.day_budget + 0.5),
                    spentToday = Math.floor(1e6 * data.spent_today + 0.5),
                    timeTargetCoef = data.timetarget_coef,
                    strategy = data.strategy || { name: '', search: { name: 'default' }, net: { name: 'default' } },
                    searchStrategy = strategy.search,
                    truncated = 0,
                    coverage = 0,
                    dayBudgetRest,
                    isPremium,
                    effPrice,
                    brokerPrice,
                    placeName,
                    possiblePrices,
                    priceDataWithoutCoef;

                if (dayBudget > 0) {
                    dayBudgetRest = dayBudget - spentToday;

                    if (dayBudgetRest > 0) {
                        // для кампаний совсем без денег с включённым дневным бюджетом рассчитываем ставки исходя из того, что денег будет больше, чем сумма дневного бюджета
                        // с появлением денег начнём рассчитывать из min(денги, дневной бюджет)
                        campRest = campRest > 0 ? Math.min(campRest, dayBudgetRest) : dayBudgetRest;
                    } else {
                        // уже перетратили дневной бюджет
                        campRest = 0;
                    }
                }

                if (0 < timeTargetCoef && timeTargetCoef < 100) {
                    // расчёт без учёта параметра timetarget_coef
                    priceDataWithoutCoef = this.calcPrice({
                        currency: data.currency,
                        price: data.price,
                        guarantee: data.guarantee,
                        premium: data.premium,
                        larr: data.larr,
                        min_price: data.min_price,
                        camp_rest: data.camp_rest,
                        day_budget: data.day_budget,
                        spent_today: data.spent_today,
                        strategy: data.strategy
                    });

                    price *= timeTargetCoef / 100;
                }

                // цена не может быть меньше константы MIN_PRICE
                price = Math.floor(1e6 * Math.max(price, MIN_PRICE) + 0.5);

                effPrice = campRest > 0 ? Math.min(campRest, price) : price;

                // вычисляем цену
                premium.concat(guarantee).some(function(item) {
                    var bidPrice = item.bid_price;

                    if (effPrice < bidPrice && bidPrice <= price) {
                        truncated = 1;
                    } else if (bidPrice <= effPrice) {
                        brokerPrice = bidPrice;
                        coverage = 1;

                        return true;
                    }

                    return false;
                });

                isPremium = brokerPrice && searchStrategy.name == 'no_premium' ? false : true;

                if (brokerPrice) {
                    if (searchStrategy.name == 'min_price') {
                        // вход в спецразмещение
                        if (brokerPrice >= premium[2].bid_price && /^(premium|both)$/.test(searchStrategy.place)) {
                            brokerPrice = premium[2].bid_price;

                            truncated = 0;

                            // т.к. в этом случае положение, куда попадает баннер, считается
                            // не по принципу "максимум возможного для выбранной ставки",
                            // а иначе, мы сразу определяем это положение здесь, а потом
                            // уже считать его не будем.
                            placeName = PRICE_PLACES.PREMIUM3;
                        }

                        // вход в гарантированные показы
                        if (brokerPrice < premium[2].bid_price && brokerPrice >= guarantee[3].bid_price && searchStrategy.place == 'both') {
                            brokerPrice = guarantee[3].bid_price;

                            truncated = 0;

                            // см. комментарий выше
                            placeName = PRICE_PLACES.GUARANTEE4;
                        }
                    }

                    if (searchStrategy.name == 'no_premium') {
                        possiblePrices = guarantee
                            .map(function(item) { return item.bid_price; })
                            .filter(function(bidPrice) { return bidPrice <= price; });

                        if (searchStrategy.place == 'highest_place') {
                            brokerPrice = possiblePrices[0];
                        } else if (searchStrategy.place == 'min_price') {
                            brokerPrice = possiblePrices[possiblePrices.length - 1];
                        }

                        if (brokerPrice > effPrice) {
                            brokerPrice = 0;
                        } else {
                            if (searchStrategy.place == 'min_price') {
                                placeName = PRICE_PLACES.GUARANTEE4;
                            }

                            truncated = 0;
                        }
                    }
                }

                // вычисляем место
                // имя блока, куда попадаем, могло быть определено ранее
                // в результате влияния стратегии "в блок по минимальной цене"
                if (isNaN(placeName)) {
                    placeName = PRICE_PLACES[(function() {
                        if (isPremium) {
                            // 1-ое место в спецразмещение
                            if (premium[0] && effPrice >= premium[0].bid_price) return 'PREMIUM1';
                            // @todo open:
                            // 2-ое место в спецразмещение
                            //if (premium[1] && effPrice >= premium[1].bid_price) return 'PREMIUM2';
                            //  вход в спецразмещение
                            if (premium[2] && effPrice >= premium[2].bid_price) return 'PREMIUM3';
                        }

                        // 1-ое место в гарантированных показах
                        if (guarantee[0] && effPrice >= guarantee[0].bid_price) return 'GUARANTEE1';
                        // вход в гарантированные показы
                        if (guarantee[3] && effPrice >= guarantee[3].bid_price) return 'GUARANTEE4';

                        if (bottom.prices.length && effPrice >= bottom.prices[0]) return 'ROTATION';
                    })()];
                }

                // если не нашлось место в гарантии - считаем покрытие
                if (!brokerPrice) {
                    coverage = calcCoverage(effPrice, bottom.prices, bottom.probs) / 1e6;

                    if (coverage) {
                        truncated = +(price > effPrice);

                        // вычисляем цену автоброкера
                        larrParts[1] &&
                            (brokerPrice = larrParts[1]
                                .split(',')
                                .map(Number)
                                .filter(function(val) { return val <= effPrice; })
                                .sort(function(v1, v2) { return v2 - v1; })[0]);

                        brokerPrice || (brokerPrice = effPrice);
                    } else {
                        brokerPrice = 0;
                    }
                }

                if (minPrice && minPrice > brokerPrice) {
                    brokerPrice = 0;
                }

                return {
                    price: roundPriceToStep(brokerPrice / 1e6, currency, 'up'),
                    coverage: coverage,
                    truncated: truncated,
                    place_name: placeName,
                    place_name_without_coef: (priceDataWithoutCoef || {}).place_name
                };
            }


function roundPriceToStep(x,y,z){
return x;
}
