#!/usr/bin/perl

use my_inc "../..";


=head1 DESCRIPTION

    Скрипт, копирующий все кампании клиента из-под одного агентства в другое.
    Использовался для переезда кампаний ламоды в другое агентство. Многое (логины, например) захардкожено с того времени!
    Использовать только с предварительным тестированием.
    Не копирует архивные кампании.

=cut

use strict;
use warnings;

use Settings;
use Yandex::DBTools;
use ScriptHelper;

use RBAC2::Extended;

use PrimitivesIds;
use Campaign::Copy;

use Yandex::Retry;

use utf8;
local $Yandex::DBShards::STRICT_SHARD_DBNAMES = 0;

our $OPERATOR_UID = 1;

$log->out('START');

my $target_agency_uid = get_uid(login => 'ad4u');
my $source_uid = get_uid(login => 'lamodasem');
my $SLEEP_TIME_COEF = 1;

$log->out('Fetching cids to copy from uid ' . $source_uid . ' to agency uid ' . $target_agency_uid);
my $cids = get_one_column_sql(PPC, [q/
    SELECT c.cid
    FROM campaigns c
    LEFT JOIN campaigns c2 ON c2.uid = c.uid AND c2.copiedFrom = c.cid AND/, {'c2.AgencyUID' => $target_agency_uid}, q/
    WHERE
        c2.cid IS NULL
        AND c.type = "text"
        AND c.statusEmpty = "No"
        AND c.archived = "No"
        AND/, {'c.AgencyUID__ne' => $target_agency_uid}, q/
        AND/, {'c.uid' => $source_uid}, q/
/]) || [];
my $total_cids_count = scalar(@$cids);
$log->out('Got ' . $total_cids_count . ' campaigns to copy');

my $rbac = _get_rbac_object();
my $copied_cids_count = 0;
for my $cid (@$cids) {
    $log->out('Copying campaign ' . $cid);
    my $new_cid = relaxed times => $SLEEP_TIME_COEF, sub {
        copy_camp($rbac, $cid, $source_uid, undef, $target_agency_uid, flags => {
            copy_ctr => 1, # копировать накопленный CTR
            copy_moderate_status => 1, # копировать статусы объявлений
            copy_phrase_status => 1, # копировать статус фраз (приостановка)
            copy_statusMail => 1, # копировать признак отправки писем об окончании средств
            copy_statusNoPay => 1, # копировать флаг запрещения оплаты кампании
            copy_sms_settings => 1, # копировать настройки уведомлений по SMS
            copy_auto_optimize_request => 1, # копировать флажок автоматически созданной заявки на оптимизацию кампании
            copy_mediaplan_status => 1, # копировать поле mediaplan_status из camp_options
            copy_camp_description => 1, # копировать примечания к кампании
            copy_notification_settings => 1, # копировать настройки уведомлений кампании (FIO email valid sendNews sendWarn sendAccNews)
            copy_bid_place => 1, # копировать позицию, на которую попадала фраза при сохранении в интерфейсе
            copy_bid_warn_status => 1, # копировать признаки отправки предупреждений о низком CTR и потере позиции
            copy_retargetings => 1, # копировать условия ретаргетинга
            copy_bids_href_params => 1, # копировать параметры ссылок (Param1, Param2, ...)
            copy_camp_secondary_options => 1, # копировать дополнительные параметры кампани (таблицу camp_secondary_options)
        },
        UID => $OPERATOR_UID,
        )
    };
    $copied_cids_count++;
    my $cids_left_count = $total_cids_count - $copied_cids_count;
    $log->out('Copied campaign ' . $cid . ' into campaign ' . $new_cid . '. Still ' . $cids_left_count . ' campaigns to copy' );
}

$log->out('FINISH');


sub _get_rbac_object {
    my $OPERATOR_UID = 1;

    my $rbac = eval { RBAC2::Extended->get_singleton($OPERATOR_UID) }
        or $log->die("Ошибка проверки прав доступа: $@");

    return $rbac;
}
