#!/usr/bin/env perl

# $Id$

use my_inc "../..";

=head1 NAME

check_db_schema_direct.pl - обёртка над db_schema.pl, умеющая писать письма и отправлять juggler-события

=head1 DESCRIPTION

    Отправляет письмо про расхождения между наблюдаемой схемой БД и тем, что записано в db_schema

    Опции:
    все, что поддерживаются db_schema.pl
    --help
        вывести справку
    --email-to
        куда писать письма
    --email-from
        от кого писать письма

=head1 METADATA

<crontab>
    time:       43 10 * * *
    params:     --dir /var/www/ppc.yandex.ru/db_schema --conf /var/www/ppc.yandex.ru/etc/db_schema.conf.json --email-to 'direct-maintenance@yandex-team.ru' --email-from 'direct_noreply@yandex-team.ru' --show_old_temporals --skip_dir stubs
    package:    scripts-switchman
    <switchman>
        group:      scripts-other
        lockname:   check_db_schema
    </switchman>
</crontab>
<juggler_check>
    host:   checks_auto.direct.yandex.ru
    name:       check_db_schema.checked
    raw_events: check_db_schema.checked.production
    ttl:        25h
    tag: direct_group_sre
</juggler_check>

=cut

use Direct::Modern;
use Encode;
use Getopt::Long;
use ScriptHelper;
use Settings;
use Sys::Hostname;

use Yandex::Shell;
use Yandex::SendMail;

use open ':std' => ':utf8';


my ($email_to, $email_from);

Getopt::Long::Configure("pass_through");
GetOptions( 
    'h|help' => sub {system("podselect -section NAME -section DESCRIPTION $0 | pod2text >&2"); exit 0;},
    'email-to=s' => \$email_to,
    'email-from=s' => \$email_from,
) || exit(1);

die "--email-to <email> required" unless $email_to;
$email_from ||= $email_to;
$Yandex::SendMail::ENVELOPE_SENDER = $email_from;

$ENV{PATH} = "/usr/local/bin:/usr/bin:/bin:/usr/local/sbin:/usr/sbin:/sbin";
my $report = yash_qx("db_schema.pl --no-svn ".join(" ", @ARGV));
$report = Encode::decode_utf8($report);
$report =~ /^\*\*\*\s*\n(.*?)\n\*\*\*\s*\n*(.*)$/s;
my ($header, $diff) = ($1, $2);

my $diff_cnt = 0;
if ($diff) {
    my @files = $diff =~ /^===([^=]\S+)$/gm;
    $diff_cnt = scalar( @files );
}

juggler_check(service => "check_db_schema.checked", description => "diffs", value => $diff_cnt, crit => 1);
unless ($diff) {
    juggler_ok();
    exit;
}

my $host = hostname();

my $subj = "db_schema: $diff_cnt diffs ($host)";
my $message = "Или файлы, или БД требуют обновления.";
my $mail_content = "host:      $host\n$header\ndiffs: $diff_cnt\n\n$message\n\n$diff\n";

Yandex::SendMail::sendmail($email_to, $email_from, $subj, \$mail_content);

juggler_ok();
exit;
