#!/usr/bin/perl

use my_inc '../..';

use Direct::Modern;
use Settings;
use Yandex::DBTools;
use Yandex::DBShards;
use PrimitivesIds;

my $client_id = shift or die "usage: $0 <ClientID|login>\n";
unless ($client_id =~ /^\d+$/) {
    $client_id = get_clientid(login => $client_id) or die "invalid login";
}

my $shard = get_shard(ClientID => $client_id) or die "client not found";

my $cr_id = get_one_field_sql(PPC(shard => $shard), "select max(creative_id) + 10 from perf_creatives");
my $cr_group_id = get_one_field_sql(PPC(shard => $shard), "select max(creative_group_id) + 10 from perf_creatives") // 10;
my $row = {
    creative_id => $cr_id,
    creative_type => 'performance',
    ClientID => $client_id,
    name => 'test creative #'.$cr_id,
    width => 200,
    height => 400,
    alt_text => '',
    preview_url => '',
    sum_geo => '',
    statusModerate => 'Yes',
    moderate_send_time => undef,
    creative_group_id => $cr_group_id,
    group_create_time => '2016-01-01 00:00:00',
    business_type => 'retail',
    theme_id => 1,
    layout_id => 1,
    template_id => 330,
};
do_insert_into_table(PPC(shard => $shard), 'perf_creatives', $row);
print "creative_id = $cr_id, creative_group_id = $cr_group_id\n";
