#!/usr/bin/perl

use warnings;
use strict;
use utf8;

use my_inc "../..";
use Settings;
use PrimitivesIds;
use Yandex::DBTools;

# --------------------------------------------------------------------
sub main {
    my $cid = $ARGV[0] or die "cid require\n";
    print "cid = $cid\n";

    do_update_table(PPC(cid => $cid), 'campaigns', {type => 'performance'}, where => {cid => $cid});
    do_replace_into_table(PPC(cid => $cid), 'campaigns_performance', {
        cid => $cid,
    });

    my $feed_id = 1001;
    my $ClientID = get_clientid(cid => $cid);
    my $creative_id = 2001; # get_new_id("creative_id", ClientID => $ClientID);
    my $bids_performance_id = 3001;
    my $condition_json = '{"categoryId" : [555,666]}';

    do_replace_into_table(PPC(cid => $cid), 'feeds', {
        feed_id => $feed_id,
        ClientID => $ClientID,
        name => 'feed name',
        url => 'http://feed.org/',
    });

    do_replace_into_table(PPC(cid => $cid), 'perf_creatives', {
        creative_id => $creative_id,
        ClientID => $ClientID,
        name => 'creative name',
        width => 640,
        height => 480,
        alt_text => 'alt_text',
        href => 'http://creative.org/',
        preview_url => '//creative.org/preview',
        sum_geo => '225',
    });

    for my $pid (@{ get_one_column_sql(PPC(cid => $cid), "select pid from phrases where cid = ?", $cid) }) {
        print STDERR "pid = $pid\n";
        do_update_table(PPC(cid => $cid), 'phrases', {adgroup_type => 'performance'}, where => {pid => $pid});

        do_replace_into_table(PPC(cid => $cid), 'adgroups_performance', {
            pid => $pid,
            feed_id => $feed_id,
        });

        do_replace_into_table(PPC(cid => $cid), 'bids_performance', {
            perf_filter_id => $bids_performance_id,
            pid => $pid,
            name => 'filter name: ' . $bids_performance_id,
            price_cpc => 1.33,
            price_cpa => 0.77,
            condition_json => $condition_json,
        }) for 1 .. 3;
        $bids_performance_id++;

        for my $bid (@{ get_one_column_sql(PPC(cid => $cid), "select bid from banners where pid = ?", $pid) }) {
            print STDERR "bid = $bid\n";
            do_update_table(PPC(cid => $cid), 'banners', {banner_type => 'performance'}, where => {bid => $bid});

            do_replace_into_table(PPC(cid => $cid), 'banners_performance', {
                bid => $bid,
                creative_id => $creative_id,
            });
        }
    }
}

# --------------------------------------------------------------------
main();
