#!/usr/bin/perl

=head1 NAME

    create_rules_vars_file.pl - создать файл с переменными для подключения в rules

=head1 DESCRIPTION

    Создать файл со списком некоторых переменных из Settings, необходимых
    для сборки пакетов (rules)

    Параметры:
    --help - справка
    --out=outfile - записать данные в указанный файл

=cut

use strict;
use warnings;

use File::Slurp;

use Yandex::Shell;

use my_inc "../..";

use Settings;
use ScriptHelper get_file_lock => undef, script_timer => undef;

my $OUT;
extract_script_params(
    "out=s" => \$OUT,
);

my @raw_host_params;
for my $h (@ScriptsMetadata::DEFAULT_JUGGLER_RAW_HOST) {
    push @raw_host_params, "--default-juggler-raw-host", $h;
}

my $vars = {
    ZOOKEEPER_SERVERS => join(',', @$Settings::ZOOKEEPER_SERVERS),
    ZOOKEEPER_PORT => $Settings::ZOOKEEPER_PORT,
    ZKHOSTS => join(',', map {"$_:$Settings::ZOOKEEPER_PORT"} @$Settings::ZOOKEEPER_SERVERS),
    ZKHOSTS_NP => join(',', map {"$_:$Settings::ZOOKEEPER_PORT"} @$Settings::ZOOKEEPER_SERVERS_NP),
    SHARDS_NUM => $Settings::SHARDS_NUM,
    SWITCHMAN_MEM_LEASE_NAME_IN_META => $Settings::SWITCHMAN_MEM_LEASE_NAME_IN_META,
    SWITCHMAN_MEM_LEASE_NAME_IN_PARAMS => $Settings::SWITCHMAN_MEM_LEASE_NAME_IN_PARAMS,
    SWITCHMAN_DEFAULT_FQDN_MEM_TOTAL => yash_quote($Settings::SWITCHMAN_DEFAULT_FQDN_MEM_TOTAL),
    DEFAULT_JUGGLER_NAME_TEMPLATE => yash_quote($ScriptsMetadata::DEFAULT_JUGGLER_NAME_TEMPLATE),
    DEFAULT_JUGGLER_RAW_EVENTS_TEMPLATE => yash_quote($ScriptsMetadata::DEFAULT_JUGGLER_RAW_EVENTS_TEMPLATE),
    JUGGLER_CHECK_RAW_HOST => yash_quote($ScriptsMetadata::JUGGLER_CHECK_RAW_HOST),
    DEFAULT_JUGGLER_RAW_HOST_PARAMS_STR => (join ' ', map { yash_quote($_ ) } @raw_host_params ),
};

require SettingsTest;   # после этой строчки в Settings::* могут быть значения, переопределённые в SettingsTest.pm
                        # не используйте Settings после этой строчки, если нужны значения из Settings.pm
$vars->{SHARDS_NUM_TEST} = $Settings::SHARDS_NUM;

my $data = join '', map {"$_=$vars->{$_}\n"} keys %$vars;
if (defined $OUT) {
    write_file($OUT, {atomic => 1}, $data);
} else {
    print $data;
}
