#!/usr/bin/perl

use my_inc "../..";


=head1 DESCRIPTION

    обертка над db_schema.pl

    передает в db_schema.pl подходяцие для рабочей копии Директа параметры:
     * каталог с сохраненными схемами 
     * конфиг (etc/db_schema.conf.json)
     * конфиг соединений БД для текущей конфигурации (из Settings)

    Самый обычный способ использования: 
    ./maintenance/db_schema_direct.pl -i

    для просмотра справки по db_schema.pl: 
    ./maintenance/db_schema_direct.pl -- -h

    вполне аналогичен Геоконтекстовому скрипту db_schema_gtx.pl (с поправкой на структуру рабочей копии)
    Существенные изменения функциональности рекомендуется либо выносить в проектнонезависимые компоненты, 
    либо аккуратно копировать и в Геоконтекст тоже

=cut

use strict;
use warnings;

use lib::abs '..';

use Settings;
use ScriptHelper;

Getopt::Long::Configure("pass_through", "no_permute");
Getopt::Long::GetOptions( 'h|help' => \&usage) || exit(1);

my $to_run = join(' ',
    'db_schema.pl',
    "--dir=$Settings::ROOT/db_schema",
    "--conf=$Settings::ROOT/etc/db_schema.conf.json",
    "--db-config=$Yandex::DBTools::CONFIG_FILE",
    '--show_old_temporals',
    @ARGV,
);

#print "to run: $to_run\n";
exit system($to_run)>>8;

