#!/usr/bin/perl

=head1 NAME

    export_client_data.pl - экспорт всех данных клиента в текстовые файлы с sql-запросами

=head1 DESCRIPTION

    скрипт нужен для создания заполненной тестовой базы
    параметры:
    --dir - директория, в которой будут создаваться фалы вида {ppc,ppcdict}.ClientID.sql
    --login - список логинов для экспорта

=cut

use strict;
use warnings;
use utf8;

use Carp qw/croak/;

use Yandex::DBShards;

use my_inc '../..';

use Settings;
use ScriptHelper;
use PrimitivesIds;
use Direct::ReShard::Exporter;

my @LOGINS;
my $DIR;
my $SORTLIST;

extract_script_params(
    "dir=s" => \$DIR,
    "login=s" => \@LOGINS,
    "sort-list=s" => \$SORTLIST,
    );

usage() if !defined $DIR || !@LOGINS;
croak "Incorrect directory $DIR" if !-d $DIR;

my $login2clientid = get_login2clientid(login => \@LOGINS);
if (my @not_found = grep {!$login2clientid->{$_}} @LOGINS) {
    croak "ClientID not found for: ".join(', ', @not_found);
}

my @sortlist;
if (defined $SORTLIST) {
    @sortlist = split /,/, $SORTLIST;
}

for my $login (@LOGINS) {
    my $resharder = Direct::ReShard->create(
        simulate => 1,
        log_data => 0,
        validate_db_schema => 0,
        orig_shard => get_shard(ClientID => $login2clientid->{$login}),
        );
    my $exporter = Direct::ReShard::Exporter->new(dir => $DIR, resharder => $resharder, sortlist => \@sortlist);
    $exporter->export_client_data($login2clientid->{$login});
}

