#!/usr/bin/perl

=pod
    $Id$

    Записывает константы из perl в JS файлики (data/js/jq/*.js)

=cut

use Direct::Modern;

use Yandex::I18n;

use File::Basename;
use File::Slurp;
use List::MoreUtils ();

use my_inc "../..";


use Currencies qw/get_currency_constant/;
use ExportConstsToJs;
use InterfaceConsts;
use Settings;


Yandex::I18n::init_i18n('ru'); # выгружаем константы на русском, т.к. ключами для iget'ов у нас являются именно русские фразы

=head2 %to_export

    Собственно константы для экспорта в js. Имеет следующий формат:
    my %to_export = (
        $filename1 => { # <ROOT>/data/js/jq/$filename1.js
            const1 => $const1_value,
            const2 => $const2_value,
        },
    );

=cut

# multicurrency -- все константы в js брать исключительно из const.js, относящееся к деньгам -- пересчитывать в разные валюты
our %to_export = (
    'const' => { # const.js
        %{InterfaceConsts::get_interface_consts()},

        # TODO: постепенно оторвать все константы ниже, как только они перестанут использоваться

        # multicurrency: хорошо бы оторвать после того, как сделаем мультивалютность в Лёгком
        # любое их использование в директе (не в Баяне!) почти гарантированно будет означать код, не приспособленный к мультивалютности
        map({$_ => get_currency_constant('YND_FIXED', $_)} qw/
            MIN_PRICE
            MAX_PRICE
            MIN_AUTOBUDGET_CLICKS_BUNDLE
            MAX_AUTOBUDGET_CLICKS_BUNDLE
            MIN_AUTOBUDGET
            MAX_AUTOBUDGET
            MIN_AUTOBUDGET_BID
            MAX_AUTOBUDGET_BID
            MIN_AUTOBUDGET_AVG_PRICE
            MIN_AUTOBUDGET_AVG_CPA
            DEFAULT_AUTOBUDGET
            RECOMMENDATION_SUM_MIN
            RECOMMENDATION_SUM_MID
            RECOMMENDATION_SUM_MAX
            RECOMMENDATION_SUM_WARN
            BRAND_SURVEY_BUDGET_THRESHOLD
            BRAND_SURVEY_BUDGET_THRESHOLD_DAILY
        /),
        ADDRESS_STREET_PREFIXES => '', # Подозрительное значение. Раньше бралось из $CommonMaps::ADDRESS_STREET_PREFIXES, но такой переменной уже нет
        MIN_AUTOBUDGET_AVG_CPI => get_currency_constant('YND_FIXED', "MIN_AUTOBUDGET_AVG_CPA"), # копия со стратегии CPA (т.к. внутри это одна стратегия)
    },
);

my %SKIP_IGET_FOR_KEYS = (
    const => [qw/
        UKR_NATIVE_LETTERS
        ALLOW_LETTERS
        ALLOW_BANNER_LETTERS
        RUS_LETTERS
        KAZ_LETTERS
    /],
);

run() unless caller();

sub run {
for my $lang ("",'ru',Yandex::I18n::get_other_langs())  {
    Yandex::I18n::init_i18n($lang, check_file => 1);
    while (my($filename, $file_constants) = each %to_export) {

        my @assignments;
        for my $js_prop_name ( sort keys %$file_constants ) {
            my $js_prop_val = $file_constants->{$js_prop_name};
            my $no_iget = List::MoreUtils::any { $js_prop_name eq $_ } @{$SKIP_IGET_FOR_KEYS{$filename}};
            push @assignments, "$js_prop_name = window.CONSTS.$js_prop_name = " . ExportConstsToJs::serialize_js_value($js_prop_val, ident => 4, no_iget => $no_iget, real_iget => ($lang?1:0));
        }

        my $content = "// файл генерируется автоматически скриптом protected/maintenance/export_consts_to_js.pl\n";
        $content .= ";window.CONSTS = {};";
        $content .= "var ";
        $content .= join ",\n    ", @assignments;
        $content .= ";";

        my $js_file_data;

        if ($lang ne "") {
            # для data3 нужны i-const.js.lang без iget
            $js_file_data = "$Settings::ROOT/data3/desktop.blocks/i-const/i-$filename.js" . "." . ($lang eq "ua" ? "uk" : $lang);

            # когда этот скрипт запускается во время сборки пакета, каталога data3 может не существовать,
            # и в таком случае i-const.js можно не записывать (он не вызывается браузером)
            next unless -d dirname($js_file_data);
        } else {
            # для data нужен const.js с iget внутри
            $js_file_data = "$Settings::ROOT/data/js/jq/$filename.js";
        }
        print "$js_file_data\n";
        write_file($js_file_data, {atomic => 1, binmode => ':utf8'}, \$content);
    }
}
}

1;
