#!/usr/bin/perl

=pod
    $Id$

    Записывает константы из perl в JS файлики (data/js/jq/*.js)

=cut

use Direct::Modern;

use Encode;
use JSON;
use Locale::PO;
use Path::Tiny;

use Yandex::I18n;
use Yandex::I18nTools;
use Yandex::HashUtils;

use my_inc "../..";

use Settings;


my $RESULT_FILE = "$Settings::ROOT/data3/desktop.blocks/i-utils/__i18n/i-utils__i18n.translations.json";

run() unless caller();


sub run {
    my %all_langs;
    for my $lang (keys %Yandex::I18n::LOCALES) {

        my $msg_hash = {};
        if (my $base_lang = Yandex::I18n::get_base_locale($lang)) {
            hash_merge $msg_hash, _get_po_hash($base_lang);
        }

        hash_merge $msg_hash, _get_po_hash($lang);

        $all_langs{$lang} = $msg_hash;
    }

    my $res_json = JSON->new()->pretty->canonical->encode(\%all_langs);

    # fix result for javascript parser
    # http://search.cpan.org/dist/JSON-XS/XS.pm#JSON_and_ECMAscript
    $res_json =~ s/\x{2028}/\\u2028/g;
    $res_json =~ s/\x{2029}/\\u2029/g;

    path($RESULT_FILE)->spew_utf8($res_json);
}


sub _get_po_hash {
    my ($lang) = @_;
    my $po_file = Yandex::I18nTools::get_po_filename($lang);
    my $po_msg_list = Locale::PO->new(-dequote => 1)->load_file_asarray($po_file);
    my %msg_hash = map {_norm($_->msgid) => _norm($_->msgstr)} @$po_msg_list; 
    delete $msg_hash{""};
    return \%msg_hash;
}

sub _norm {
    return Encode::decode_utf8(Locale::PO->dequote($_[0]));
}

1;
