#!/usr/bin/perl

use my_inc "../..";


=head1 NAME

extract_template_bindings_pod.pl

=head1 DESCRIPTION

выводим pod функций, которые прокинуты в шаблоны

=cut

use strict;
use warnings;
use utf8;
use open qw(:std :utf8);

use File::Slurp;
use Pod::Find qw/pod_where/;
use PPI;
use YAML;

my $doc = PPI::Document->new('protected/DoCmd.pm');
my $symbols = $doc->find(sub {$_[1]->isa('PPI::Token::Symbol') && $_[1]->content eq '%CONFIG'});

my $functions = {map {$_->sprevious_sibling->sprevious_sibling->sprevious_sibling->content => $_->content} @{$symbols->[0]->parent->find(sub {$_[1]->isa('PPI::Token::Symbol') && $_[1]->content =~ /^&.*::/})}};

my $result = {};
for my $name (keys %$functions) {
    my $ref = $functions->{$name};
    my ($package, $sub_name) = $ref =~ /^&(.*)::([^:]+)$/;
    my $file = pod_where({-inc => 1}, $package);
    my $content = read_file($file, binmode => ':utf8');
    if ($content =~ /^=head2\s+$sub_name.*?\n(.*?)^=cut\s*/sm) {
        $result->{$name} = $1;
    }
}

print Dump $result;
