#!/usr/bin/perl

use my_inc "../..";


=pod HEAD 1

    забираем названия и урлы для всех агентств из баланса
    https://jira.yandex-team.ru/browse/DIRECT-2504

=cut

use warnings;
use strict;

use Yandex::Balance;
use Yandex::DBTools;

use RBAC2::Extended;
use RBACDirect;
use RBACElementary;
use Settings;

our $OPERATOR_UID;
our $rbac;

print STDERR "config: $Settings::CONFIGURATION\n";

$|++;

#-----------------------------------------------------------
sub main
{
    print STDERR "init\n";
    $OPERATOR_UID = 1;

    $rbac = RBAC2::Extended->get_singleton($OPERATOR_UID);

    # get all agencies
    my $all_agencies = rbac_get_all_agencies($rbac);
    print STDERR "found: " . scalar(@$all_agencies)." agencies\n";

    # get info
    my %already;
    for my $ag_uid (@$all_agencies) {

        my $ClientID = rbac_get_agency_clientid_by_uid( $ag_uid);
        print STDERR "$ag_uid / $ClientID\n";

        next if $already{$ClientID};
        $already{$ClientID}++;

        unless (get_one_field_sql(PPC(ClientID => $ClientID), "select count(*) from users where uid = ? and ClientID = ?", $ag_uid, $ClientID)) {
            print STDERR "$ag_uid / $ClientID not found in db\n";
            next;
        }

        my $agency = get_client_by_uid($ag_uid);
        next if ref($agency) ne 'HASH'
                || ! defined $agency->{NAME}
                || ! defined $agency->{URL}
                || $agency->{NAME} =~ /^[_-]?$/
                || $agency->{URL}  =~ /^[_-]?$/;

        do_sql(PPC(ClientID => $ClientID), "insert into clients (ClientID, name, agency_url)
                      values (?, ?, ?)
                      on duplicate key update
                        name = values(name)
                        , agency_url = values(agency_url)"
               , $ClientID, $agency->{NAME}, $agency->{URL});
    }
}

#-----------------------------------------------------------
main();
