#!/usr/bin/perl

use my_inc "../..";


=head1 NAME
    
    fill_currency_rates.pl

=head1 DESCRIPTION

    Добавить в базы PPCDICT, PPC  курсы валют на указанную дату или диапазон дат.
    Для заполнения используются курсы на последнюю дату в PPCDICT. Если на эти даты уже есть курсы, то они перезаписываются.

    Скрипт должен использоваться ТОЛЬКО в тестовой среде.

    Параметры:
    --help, h - справка
    --date=date - дата, на которую необходимо проставить курсы валют.
    --from=date, --to=date - задают диапазон дат, для которых нужно проставить курсы валют.
        По умолчанию диапазон начинается с последней даты, на которую есть курсы в PPCDICT (не включительно), и заканчивается завтрашним днём (включительно).

    Примеры:
    ./fill_currency_rates.pl
        - заполняет с последней даты в PPCDICT до завтрашнего дня.
    ./fill_currency_rates.pl --date=2014-01-01
    ./fill_currency_rates.pl --from=2014-01-01
    ./fill_currency_rates.pl --to=2014-01-31
    ./fill_currency_rates.pl --from=2014-01-01 --to=2014-01-31

=cut
    
use warnings;
use strict;

use lib::abs '..';
use Settings;
use ScriptHelper;
use Yandex::DBTools;
use Yandex::TimeCommon;
use Yandex::Validate qw/is_valid_date/;
use Currencies;
use EnvTools;
use ShardingTools;

use utf8;
use open ':std' => ':utf8';

die "Скрипт должен использоваться только в тестовой конфигурации" if is_production();

my @dbs = (PPCDICT, PPC(shard => [ppc_shards()]) );
my @currencies = map {$_->{BALANCE_CURRENCY_NAME} || ()} values %Currencies::_CURRENCY_DESCRIPTION;

my $main_db = PPCDICT;

my ($date_on, $date_from, $date_to, $help);
extract_script_params(
           'date=s' => \$date_on,
           'from=s' => \$date_from,
           'to=s' => \$date_to,
);


if (($date_on && $date_from) || ($date_on && $date_to)) {
    die "Нужно указать либо одну дату, либо диапазон дат";
}   

foreach my $date_value ($date_on, $date_from, $date_to) {
    die "Неправильный формат даты: $date_value" if defined($date_value) && !is_valid_date($date_value);
}

my @dates;
if ($date_on) {
    @dates = ($date_on);
} else {
    $date_from ||= tomorrow(get_one_field_sql($main_db, 'SELECT MAX(date) FROM currency_rates'));
    $date_to ||= tomorrow();
    @dates = get_distinct_dates($date_from, $date_to);
}

exit 0 unless @dates;

my %currency_rates =  map {
                   ($_ => get_one_field_sql($main_db, 'SELECT rate FROM currency_rates WHERE currency = ? ORDER BY date DESC LIMIT 1', $_))
                      } @currencies;


for my $date (@dates) {
    my @data_to_insert;
    for my $db (@dbs) {
        for my $currency (@currencies) {
            my $rate = $currency_rates{$currency};
            push @data_to_insert, [$currency, $date, $rate];
        }
        do_mass_insert_sql($db, 
            "INSERT INTO currency_rates (currency, date, rate) VALUES %s ON DUPLICATE KEY UPDATE rate = VALUES(rate)", \@data_to_insert);
    }
}
