#!/usr/bin/perl

use my_inc "../..";


=head1 DESCRIPTION

    Заменяет нулевые цены в сети для кампаний с отдельным размещением на минимальные ставки

    Опционально принимает список логинов главных представителей, кампании в которых надо чинить

    ./protected/maintenance/fix-zero-price_context-for-different_places.pl
    LOG_TEE=1 ./protected/maintenance/fix-zero-price_context-for-different_places.pl --login holodilnikru

=cut

use strict;
use warnings;

use Settings;
use ScriptHelper;

use Yandex::DBTools;
use Yandex::DBShards;
use Yandex::ListUtils qw(chunks);

use Currencies;
use PrimitivesIds;
use ShardingTools;

use utf8;

$log->out('START');

my @logins;
extract_script_params(
    'login=s' => \@logins,
);

my @currencies = keys %Currencies::_CURRENCY_DESCRIPTION;
my %currency2min_price = map { $_ => get_currency_constant($_, 'MIN_PRICE') } @currencies;
my $price_context_min_price_case_sql = sql_case('#currency#', \%currency2min_price, default__dont_quote => 'bi.price_context');
$price_context_min_price_case_sql =~ s/`#currency#`/IFNULL(c.currency, "YND_FIXED")/;

my ($shard_key, $shard_values);
if (@logins) {
    $log->die("No logins given") unless @logins;
    my @uids = @{get_uids(login => \@logins)};
    $log->die("No uids found for logins") unless @uids;
    $shard_key = 'uid';
    $shard_values = \@uids;
} else {
    $shard_key = 'shard';
    $shard_values = [ppc_shards()];
}

foreach_shard($shard_key => $shard_values, sub {
    my ($shard, $values) = @_;

    my %additional_cond;
    if ($shard_key eq 'uid') {
        $additional_cond{'c.uid'} = $values;
    }

    my $shard_prefix_guard = $log->msg_prefix_guard("[shard_$shard]");

    my %tables = (
        bids => {},
        bids_arc => {'c.archived' => 'Yes'},
    );

    my %fix_cond = (
        'co.strategy' => 'different_places',
        'c.statusEmpty' => 'No',
        'bi.price_context' => 0,
    );

    while (my ($table, $cond) = each %tables) {
        my $table_prefix_guard = $log->msg_prefix_guard("[shard_$shard]\t[$table]");
        $log->out('Fetching phrases with zero price_context in different_places campaigns');
        my $phrases = get_all_sql(PPC(shard => $shard), [qq!
            SELECT co.cid, bi.id
            FROM camp_options co
            INNER JOIN campaigns c ON c.cid = co.cid
            INNER JOIN $table bi ON bi.cid = co.cid
         !, WHERE => {
                %fix_cond,
                %additional_cond,
                %$cond,
            },
        ]);
        my $phrases_cnt = scalar @$phrases;
        $log->out("Got $phrases_cnt phrases to fix");

        if ($phrases_cnt > 0) {
            $log->out('Fixing phrases');
            for my $phrases_chunk (chunks $phrases, 1_000) {
                my (@cids, @ids);
                for my $phrase (@$phrases_chunk) {
                    $log->out($phrase);
                    push @cids, $phrase->{cid};
                    push @ids, $phrase->{id};
                }
                do_sql(PPC(shard => $shard), [qq(
                    UPDATE $table bi
                    INNER JOIN campaigns c ON bi.cid = c.cid
                    INNER JOIN camp_options co ON bi.cid = co.cid
                    SET bi.price_context = $price_context_min_price_case_sql,
                        bi.statusBsSynced = "No"
                 ), WHERE => {
                     %fix_cond,
                    'bi.cid' => \@cids,
                    'bi.id' => \@ids,
                 }]);
            }
            $log->out('Done fixing phrases');
        } else {
            $log->out('No phrases to fix');
        }
    }
});

$log->out('FINISH');
