#!/usr/bin/perl

=head2

Добавляем текущие (bids.id, bids.PhraseID, и то же из bids_arc) в bids_phraseid_associate если они там отсутствуют

=cut

use strict;
use warnings;

use utf8;
use List::Util qw/min max/;

use Yandex::DBTools;

use my_inc "../..";

use Settings;
use ShardingTools;
use ScriptHelper;

$log->out("start");

my ($CID_FROM, $CID_TO);
my $STEP = 1000;
my @SHARDS;
extract_script_params(
    "cid-from=i" => \$CID_FROM,
    "cid-to=i" => \$CID_TO,
    "step=i" => \$STEP,
    "shard-id=i" => \@SHARDS,
);

$CID_FROM //= 0;
$CID_TO //= max @{get_one_column_sql(PPC(shard => 'all'), "select max(cid) from campaigns") || []};
@SHARDS = ppc_shards() if !@SHARDS;

for(my $from = $CID_FROM; $from <= $CID_TO; $from += $STEP) {
    my $to = min($from + $STEP - 1, $CID_TO);
    $log->out("start processing cids $from .. $to");
    for my $shard (@SHARDS) {
        my $log_prefix = $log->msg_prefix();
        foreach my $tbl (qw/bids bids_arc/) {
            $log->msg_prefix("[shard_$shard] $tbl: ");
            my $to_insert = get_all_sql(PPC(shard => $shard), "
                                    SELECT bi.cid, bi.pid, bi.PhraseID, bi.id bids_id, bi.modtime
                                      FROM $tbl bi
                                 LEFT JOIN bids_phraseid_associate bia 
                                        ON bia.cid = bi.cid and bia.pid = bi.pid and bia.PhraseID = bi.PhraseID 
                                           and (bia.bids_id = bi.id or bia.logtime = bi.modtime)
                                     WHERE bi.cid between ? and ?
                                       AND bi.PhraseID > 0
                                       AND bia.cid is null", 
                        $from, $to
                );
            my $to_insert_count = scalar(@$to_insert);
            $log->out("$to_insert_count rows fetched");
            $log->out(@$to_insert);

            if (@$to_insert) {
                my $inserted_count = do_mass_insert_sql(PPC(shard => $shard), 'insert ignore into bids_phraseid_associate (cid, pid, bids_id, PhraseID, logtime) values %s'
                                                                            , [ map { [@{$_}{qw/cid pid bids_id PhraseID modtime/}] } @$to_insert ]);
                $inserted_count += 0;
                $log->out("$inserted_count rows inserted");
                $log->out(($to_insert_count - $inserted_count) . " rows skipped") if $to_insert_count > $inserted_count;
            }
            $log->msg_prefix($log_prefix);
        }
    }
}

$log->out("finish");
