#!/usr/bin/perl

use my_inc "../..";


=pod

  https://jira.yandex-team.ru/browse/DIRECT-10047

  находим все кампании с uid не шефа и меняем на правильный

=cut

use strict;
use warnings;

use Yandex::DBTools;
use Yandex::Log;

use Common ':subs';
use RBAC2::Extended;
use RBACElementary;
use Settings;

my $rbac = RBAC2::Extended->get_singleton(1);

#-----------------------------------------------------------
sub main
{
    do_sql(PPC(shard => 'all'), "SET SESSION group_concat_max_len = 1000000");
    my $log = Yandex::Log->new(log_file_name => "fix_chiefs_uid_on_campaigns.log");

    my $all_uids_with_many_reps = get_all_sql(PPC(shard => 'all'), "
        select u.ClientID, GROUP_CONCAT(distinct c.uid) as camp_uids
        from campaigns c
          join users u using(uid)
        where u.ClientID > 0
        group by u.ClientID
        having count(distinct c.uid) > 1
    ");

    printf STDERR "all bad clients: %i\n", scalar(@$all_uids_with_many_reps);

    for my $row (@$all_uids_with_many_reps) {
        my $ClientID = $row->{ClientID};
        my @uids = split /,/, $row->{camp_uids};
        my $chief_rep_uid = rbac_get_chief_rep_of_client($ClientID) || next;

        for my $old_uid (@uids) {
            next if $old_uid == $chief_rep_uid; # уже шеф, пропускаем
            change_uid($old_uid, $chief_rep_uid);
            $log->out({old_uid => $old_uid, chief_rep_uid => $chief_rep_uid, ClientID => $ClientID, camp_uids => $row->{camp_uids}});
        }
    }
}

main();
