#!/usr/bin/perl

use my_inc "../..";

=head1 NAME

    fix_cpm_productids.pl -- заменяет ProductID из продакшена на тестовые значения в таблицах ppc.campaigns и ppcdict.products для кампаний cpm_banners.
    Нужно т. к. cейчас у Баланса различаются продукты для cpm кампаний в тестинге и продакшене.

    вызывается из protected/maintenance/prepare_test_db.pl

    https://st.yandex-team.ru/DIRECT-75376

=cut

use strict;
use warnings;

use ScriptHelper;

use Settings;
use EnvTools;
use Yandex::DBTools;
use ShardingTools;

use utf8;
use open ':std' => ':utf8';

#..............................................................................
my $prod_productid2test_productid = {
    508587 => { ProductID => 508575}, # Тест. Директ CPM, RUB
    508590 => { ProductID => 508566}, # Тест. Директ CPM, UAH
    508596 => { ProductID => 508571}, # Тест. Директ CPM, квази KZT
    508892 => { ProductID => 508579}, # Тест. Директ CPM, KZT
    508588 => { ProductID => 508564}, # Тест. Директ CPM, USD
    508589 => { ProductID => 508565}, # Тест. Директ CPM, EUR
    508597 => { ProductID => 508569}, # Тест. Директ CPM, фишки
    508592 => { ProductID => 508568}, # Тест. Директ CPM, TRY
    508591 => { ProductID => 508567}, # Тест. Директ CPM, CHF
    508594 => { ProductID => 508570}, # Тест. Директ CPM, BYN

    508756 => { ProductID => 508559}, # Тест. Директ в квазивалютном тенге
};

#..............................................................................
sub main
{
    $log->die("$0 in production!") if is_production();

    $log->out("START");

    $log->out("Update ProductID in PPCDICT.products...");
    my $updated_prod = do_mass_update_sql(PPCDICT, 'products', 'ProductID', $prod_productid2test_productid);
    $log->out("Updated $updated_prod records in products");
    foreach my $shard (ppc_shards()) {
        my $msg_prefix_guard = $log->msg_prefix_guard("[shard $shard]");
        $log->out("Getting cpm_banner campaigns with wrong ProductIDs...");
        my $cids_to_update = get_one_column_sql(PPC(shard => $shard) , ["SELECT cid FROM campaigns",
            where => {ProductID => [ keys %$prod_productid2test_productid]}]);
        $log->out("Got ". scalar @$cids_to_update ." campaigns to update:", $cids_to_update);
        $log->out("Update ProductID in campaigns...");
        my $updated_camp = do_mass_update_sql(PPC(shard => $shard), 'campaigns', , 'ProductID', $prod_productid2test_productid, where => {cid => $cids_to_update});
        $log->out("Updated $updated_camp records in campaigns");
    }

    $log->out("FINISH");
}

#..............................................................................
main();
