#!/usr/bin/perl

=pod
    $Id$
    Скрипт рекомендуется запускать при смене леммера
    апдейтит нормализованые фразы в bids

    Кроме того, нормализованные фразы или их хеши есть в таблицах: 

    ppc.mcb_phrases               -- скрипт fix_norm_phrases.mcb_phrases.pl
    ppcdict.mcb_theme_phrases     -- скрипт fix_norm_phrases.mcb_theme_phrases.pl

    ppcdict.forecast_ctr          -- а не проще ли таблицу удалить и заново создать скриптом ppcCalcCTR.pl ?

    ppcdict.suggest_phrases       -- можно просто перегенерировать скриптом ppcSuggest.pl (после обновления bids)
    ppcdict.suggest_phrases_links -- можно просто перегенерировать скриптом ppcSuggest.pl (после обновления bids)

=cut

=head2 RUNNING

    Принимает параметры:
        --shard-id <N>
        --no-debug    — если указан, результаты пишутся в БД. по умолчания результаты выводятся в консоль, БД не изменяется.
        --level <num> — степень параллельности. по умолчанию обработка ведётся в 4 потока.
        --portion-size <num> — количество кампаний в одной порции, обрабатываемой процессом за раз
        --start-bids-cid <cid> - номер кампании, с которого начинать для таблицы bids
        --start-bids-arc-cid <cid> - номер кампании, с которого начинать для таблицы bids_arc
        --sleep-coef <num> — коэффициент, влияющий на длину паузы между UPDATE'ами. Длина паузы = <время предыдущего UPDATE'а>*<sleep-coef>

=cut

use strict;
use warnings;

use List::Util qw/max/;
use Parallel::ForkManager;

use Yandex::DBTools;
use Yandex::MyGoodWords;
use Yandex::Retry;

use my_inc "../..";

use Settings;
use HashingTools;
use ShardingTools;
use PhraseText qw/get_phrase_props/;
use ScriptHelper;

use utf8;
use open ':std' => ':utf8';

my @SHARDS = ();
my $DEBUG = 1;
my $LEVEL = 8;
my $CHUNK_SIZE = 20_000;
my $START_CID = 0;
my $SLEEP_COEF = 2;
extract_script_params(
    'shard-id' => \@SHARDS,
    'debug!' => \$DEBUG,
    'level=i' => \$LEVEL,
    'chunk-size=i' => \$CHUNK_SIZE,
    'start-cid=i' => \$START_CID,
    'sleep-coef=i' => \$SLEEP_COEF,
);
@SHARDS = ppc_shards() if !@SHARDS;

$log->out('START');

$log->out('Collecting portions');
$log->{lock} = 1;
my $max_cid = max @{get_one_column_sql(PPC(shard => 'all'), "SELECT max(cid) FROM campaigns")};

my $pm = new Parallel::ForkManager($LEVEL);

{
my $orig_norm_phrase = \&Yandex::MyGoodWords::norm_words;
my %CACHE;
*Yandex::MyGoodWords::norm_words = sub {
    if (keys %CACHE > 500_000) {
        $log->out('Cleaning cache');
        %CACHE = ();
    }
    return $CACHE{$_[0]} //= $orig_norm_phrase->($_[0]);
}
}

my $cur_cid = $START_CID;
while($cur_cid < $max_cid) {
    for my $shard (@SHARDS) {
        $pm->start and next;

        for my $tbl (qw/bids bids_arc/) {
            $log->msg_prefix("[shard=$shard,pid=$$]");
            $log->out("SELECT $tbl cid >= [$cur_cid]");
            my $sth = exec_sql(PPC(shard => $shard), "SELECT id, phrase, norm_phrase, pid, cid
                                FROM $tbl
                                WHERE cid >= ? AND cid < ?
                                 -- AND norm_phrase like '%-!%'
                            ", $cur_cid, $cur_cid+$CHUNK_SIZE);
            my ($changed, $unchanged) = (0, 0);
            while( my ($id, $phrase, $norm, $pid, $cid) = $sth->fetchrow_array() ) {
                my $props = get_phrase_props($phrase);
                my $new_norm = $props->{norm_phrase};
                if (!defined $new_norm) {
                    $log->out("Error for phrase: '$phrase'");
                    #print "phrase: $phrase\n";
                } elsif ($norm ne $new_norm) {
                    $changed++;
                    my $numw = (my @norm = split( / /, $new_norm ));
                    my $md5 = md5_hex_utf8($new_norm);
                    $log->out("'$norm' -> '$new_norm', phrase: '$phrase', id=$id");
                    if (!$DEBUG) {
                        relaxed times => $SLEEP_COEF, sub {
                            do_sql(PPC(shard => $shard), "UPDATE $tbl SET norm_phrase = ?, numword = ?, modtime = modtime WHERE id = ? and phrase = ? AND pid = ? AND cid = ?",
                                   $new_norm, $props->{numword}, $id, $phrase, $pid, $cid);
                        };
                    }
                } else {
                    $unchanged++;
                }
            }
            $log->out("stats: changed $changed/".($changed+$unchanged));
        }
        
        $pm->finish;
    }
    $cur_cid += $CHUNK_SIZE;
}
$pm->wait_all_children;

$log->out('FINISH');
