#!/usr/bin/perl

use my_inc "../..";


=pod DESCRIPTION

  очищаем users.statusArch, для субклиентов без сервисируемых кампаний
  чтобы после получения свободы такие клиенты не стали архивными у менеджера

  скрипт замена запросу который блокирует users:

  update users set statusArch = 'No'
  where not exists (select 1
                    from campaigns c
                    where c.uid = users.uid
                      and AgencyUID is null
                      and statusEmpty = 'No'
                   )
        and users.statusArch = 'Yes';

=cut

use warnings;
use strict;

use Yandex::DBTools;

use Settings;
use ShardingTools qw/ppc_shards/;

print STDERR "config: $Settings::CONFIGURATION\n";

$|++;

#-----------------------------------------------------------
sub main
{
    for my $shard (ppc_shards()) {
        my $uids = get_one_column_sql(PPC(shard => $shard), 
                                      "select uid
                                        from campaigns
                                        group by uid
                                        having sum(IF(AgencyUID is null     and statusEmpty = 'No', 1, 0)) = 0
                                           and sum(IF(AgencyUID is not null and statusEmpty = 'No', 1, 0)) > 0
                                       ") || [];
        printf "pure subclients count: = %i\n", scalar @$uids;
        return unless @$uids;

        my $update_count = do_update_table(PPC(shard => $shard), users => {statusArch => 'No'}
                                           , where => {uid => $uids, statusArch => 'Yes'});
        print "update subclients count: $update_count\n";
    }
}

#-----------------------------------------------------------
main();
