#!/usr/bin/perl

use my_inc "../..";


=head1 NAME

    fix_vcard_empty_geo_id.pl

=head1 DESCRIPTION

    Скрипт для починки визиток, который ссылаются на несуществующий адрес (запись в addresses)

    Принимает опциональный параметр:
        --shard-id=NN   - номер шарда для обработки (если не указан - будут обработаны все шарды)

=cut

use strict;
use warnings;

use Settings;
use Yandex::DBTools;
use Yandex::Retry;
use ScriptHelper sharded => 0;
use Lang::Guess qw/analyze_text_lang/;
use EnvTools;
use ShardingTools;
use CommonMaps;
use Metro;

use List::MoreUtils qw/any/;

use JavaIntapi::GeosearchSearchObject;

use utf8;

# На бетах qeryrec не доступен.
local $Lang::Guess::EXTERNAL_QUERYREC = sub { return {eng => 1}; } if !is_production();

$log->out('START');

my @all_ppc_shards = ppc_shards();
my $one_shard;
extract_script_params(
    'shard-id=i'    => \$one_shard,
);
if ($one_shard) {
    $log->die('Invalid shard number: ' . ($one_shard||'undef')) unless any { $_ == $one_shard } @all_ppc_shards;
} else {
    $log->out('All shards will be processed');
}



foreach my $SHARD ($one_shard || @all_ppc_shards) {
    $log->out("Processing shard $SHARD");

    my $data = get_all_sql(PPC(shard => $SHARD), q/
        SELECT vc.vcard_id, vc.address_id, vc.cid
             , vc.country, vc.city, vc.street, vc.house, vc.build, vc.apart
          FROM vcards vc
               LEFT JOIN addresses a on a.aid = vc.address_id
         WHERE IFNULL(vc.address_id, 0) > 0
               AND a.aid IS NULL
    /);

    # ClientID нужен для сохарения адреса
    # copy-paste из Primitives::get_clientids_by_cids, чтобы не ходить в метабазу
    my $cid2clientids = get_hash_sql(PPC(shard => $SHARD), [q/
            SELECT c.cid, u.ClientID
              FROM campaigns c
                   INNER JOIN users u ON u.uid = c.uid
        /, where => {'c.cid' => [map {$_->{cid}} @$data] }
    ]);

    foreach my $row (@$data) {
        my $ClientID = $cid2clientids->{ $row->{cid} };
        my ($new_address_id, $msg);

        if ($ClientID && $row->{city}) {
            my $address = CommonMaps::_get_address_form($row);
            $address = CommonMaps::_filter_address($address);

            # почти copy-paste из CommonMaps::check_address_map
            my $maps_from_geocoder;
            eval {
                retry tries => 3, pauses => [1, 3], sub {
                    my ($maps_from_geocoder, $error) = JavaIntapi::GeosearchSearchObject->_search_address($address, {lang => get_lang($address)});
                };
            };
            $log->warn($@) if $@;

            # В случае, если запрос к гео-кодеру не удался, _select_first_point вернет "всю землю"
            # а _save_address не будет её сохранять без указанной ручной точки.
            my $map = CommonMaps::_select_first_point($maps_from_geocoder, $row->{city});
            if (defined $map->{precision} && $map->{precision} ne 'other'
            ) {
                eval {
                    retry tries => 3, sub {
                        my $metro = search_metro((map { $map->{point}->{$_} } qw/x y/), $row->{city}, 'direct.yandex.ru');
                        $map->{metro} = $metro;
                    };
                };
                $log->warn($@) if $@;                        
            } #/ конец copy-paste

            # пытаемся сохранить новую координату-привязку к адресу
            my $result = CommonMaps::_save_address($ClientID, $map, $address);
            if ($result->{aid}) {
                $new_address_id = $result->{aid};
                $msg = 'saved new address';
            } else {
                $new_address_id = 0;
                $msg = 'no point found/saved for this address';
            }
        } else {
            # эту визитку уже не спасти - нет ClientID
            $new_address_id = 0;
            $msg = 'no ClientID or city defined for this vcards';
        }

        my $banners_to_resync = [];
        if ($new_address_id) {
            # если есть новый адрес - после обновления переотправим баннеры
            $banners_to_resync = get_all_sql( PPC(shard => $SHARD), [
                'SELECT cid, bid FROM banners b',
                WHERE => {
                    vcard_id => $row->{vcard_id},
                    'b.statusBsSynced' => 'Yes',
                },
            ]);
        }

        # делаем хеш пригодным к использованию в качестве where-condition
        delete $row->{vcard};
        foreach my $key (keys %$row) {
            next if defined $row->{$key};
            $row->{ $key.'__is_null' } = 1;
            delete $row->{$key};
        }

        relaxed times => 3, sub {
            $log->out("Update vcard #$row->{vcard_id} set address_id = $new_address_id ($msg)");
            my $updated = do_update_table( PPC(shard => $SHARD), 'vcards',
                { address_id => $new_address_id },
                where => $row
            );

            if ( ($updated + 0) && @$banners_to_resync ) {
                do_mass_insert_sql( PPC(shard => $SHARD),
                    'INSERT IGNORE INTO bs_resync_queue (cid, bid) VALUES %s',
                    [ map {[ $_->{cid}, $_->{bid} ]} @$banners_to_resync ],
                );
                $log->out("banners ro resyns: ".join(", ", map {$_->{bid}} @$banners_to_resync)) if @$banners_to_resync;
            }

            $log->out("updating vcard #$row->{vcard_id} failed") unless ($updated + 0);
        };
    }
}
$log->out('FINISH');
exit;

sub get_lang {
    my $text_lang = analyze_text_lang(shift) || '';
    if ($text_lang eq 'uk') {
        return 'uk-UA';
    } elsif ($text_lang eq 'en') {
        return 'en-US';
    } elsif ($text_lang eq 'tr') {
        return 'tr-TR';
    } else {
        return 'ru-RU';
    }
}
