#!/usr/bin/perl

use my_inc "../..";


#################################################
#
#  new forecast stress test
#  $Id$
#
#################################################

use warnings;
use strict;

use Yandex::HashUtils;

use Settings;
use ScriptHelper;
use PhraseText;
use Forecast;
use Yandex::DBTools;

use Time::HiRes qw/time/;
use Data::Dumper;

our $MAX_CHILDS = 5;
our $PHRASES_IN_PACKET = 5;
our $MAX_ITERATIONS = 10;
our $TEST_ONLY_BS_ADVQ = 0;

our @all_phrases;
$|++;

#-----------------------------------------------------------
sub main
{
    extract_script_params(
        "childs=i" => \$MAX_CHILDS,
        "phrases=i" => \$PHRASES_IN_PACKET,
        "iterations=i" => \$MAX_ITERATIONS,
        "onlybs" => \$TEST_ONLY_BS_ADVQ,
    );

    @all_phrases = @{ get_one_column_sql(PPC(shard => 'all'), 'select phrase from bids limit 100000') || [] };

    print Dumper({
         MAX_CHILDS => $MAX_CHILDS,
         PHRASES_IN_PACKET => $PHRASES_IN_PACKET,
         MAX_ITERATIONS => $MAX_ITERATIONS,
         TEST_ONLY_BS_ADVQ => $TEST_ONLY_BS_ADVQ
    });

    for (1 .. $MAX_CHILDS) {

        my $child_pid = fork();
        if ($child_pid) {
            next; # this is parent
        } elsif (defined $child_pid) { # $child_pid == 0
            do_child();
            return;
        } else {
            die "fork error\n";
        }
    }

    my $child_pid = wait();
    while ($child_pid != -1) {
        #print "$child_pid terminate\n";
        $child_pid = wait();
    }
}

#-----------------------------------------------------------
sub do_child
{
    my $cnt = 0;
    my $all_t = 0;
    my $min = 100000000;
    my $max = 0;
    my $all_tt = time();
    my $geo = 0;

    my $dbh;

    for (1 .. $MAX_ITERATIONS) {
        my $tt = time();

        #.........................................
        my @phrases;
        for (1 .. $PHRASES_IN_PACKET) {
            my $ph = $all_phrases[int(rand() * ($#all_phrases + 1))];
            push @phrases, {phrase => $ph};
        }

        if ($TEST_ONLY_BS_ADVQ) {
            process_only_bs_advq($geo, @phrases);
        } else {
            all_process($dbh, $geo, @phrases);
        }

        #.........................................

        my $t = time() - $tt;
        $all_t += $t;
        $min = $t if $t < $min;
        $max = $t if $t > $max;
        $cnt++;
    }

    printf "count: $cnt in %0.2f sec, avg: %0.2f sec, min: %0.2f, max: %0.2f\n", time() - $all_tt, $all_t / $cnt, $min, $max;
}

#-----------------------------------------------------------
sub process_only_bs_advq
{
    my $geo = shift;
    my @phrases = @_;

    for my $ph (@phrases) {
        my $props = get_phrase_props($ph->{phrase}) || next;
        hash_merge $ph, hash_cut $props, qw/norm_phrase/;
    }
    Forecast::get_advq_shows_of_phrases(\@phrases, {}, $geo, 1);
    #print STDERR Dumper(\@phrases);
}

#-----------------------------------------------------------
sub all_process
{
    my $dbh = shift;
    my $geo = shift;
    my @phrases = @_;

    my $block = {
          'Phrases' => [
                         map {{'phrase' => $_->{phrase}}} @phrases
                       ],
          'ajax' => '1',
          'cmd' => 'calcForecast',
          'geo' => $geo,
          'login_rights' => {
                              'role' => 'client'
                            },
          'no_auto_catalog' => '1',
          'phrases' => join(',', map {$_->{phrase}} @phrases),
          'sort' => 'phrase',
          'uid_url' => '',
          'currency' => 'YND_FIXED',
        };

    Forecast::forecast_calc([$block]);
    #print STDERR Dumper($block);
}

#................................................
main();
