#!/usr/bin/perl

=head1 NAME


=head1 DESCRIPTION


=cut

use strict;
use warnings;

use my_inc '../..';

use utf8;
use open ':std' => ':utf8';

use Currencies;
use Currency::Texts ();
use BannerFlags qw//;
use Settings;

use Yandex::I18n;

use List::MoreUtils qw/uniq/;
use Path::Tiny;
use JSON;

use open ':std' => ':utf8';
use utf8;

my @texts;

my $currency_constants = Currencies::get_consts_for_js();
for my $cur (keys %$currency_constants) {
    for my $field (qw/name full_name/) {
        push @texts, $currency_constants->{$cur}{$field};
    }
}

my $currency_descriptions = Currency::Texts::get_currency_texts_description_for_js();

for my $text_key (keys %$currency_descriptions) {
    for my $cur (keys %{ $currency_descriptions->{$text_key} }) {
        my $text_value = $currency_descriptions->{$text_key}->{$cur};
        next unless $text_value;
        push @texts, $text_value;
    }
}

for my $section (keys %BannerFlags::AD_WARNINGS) {
    for my $text_type ('long_text', 'short_text',) {
        my $text_value = $BannerFlags::AD_WARNINGS{$section}->{$text_type};
        next unless $text_value;
        push @texts, $text_value;
    }
}

@texts = uniq(sort(@texts));
for my $lang ("ru", Yandex::I18n::get_other_langs())  {
    Yandex::I18n::init_i18n($lang, check_file => 1);
    my %translations;
    for my $t (@texts){
        $translations{$t} = iget($t);
    }

    # data3/desktop.blocks/common-i18n/common-i18n.i18n/{ru,en,uk,tr}.js
    my $data = to_json(\%translations, { pretty => 1 });
    my $file = "$Settings::ROOT/data3/desktop.blocks/common-i18n/data/$lang.json";
    print "$file\n";
    path($file)->spew_utf8( $data );
}
