#!/usr/bin/perl

use my_inc "../..";


=head1 NAME

    get_watched_hosts.pl

=head1 DESCRIPTION

    Список хостов для проверки downtime_watcher'ом

=cut

use strict;
use warnings;

use List::MoreUtils qw/uniq/;
use POSIX qw/strftime/;
use Settings;
use Yandex::DBTools;

my $DONT_WATCH_RE = qr/^(unit_tests|fake|ppchouse:ppc:shards)/i;

print "# generated by $0 at " . strftime("%Y-%m-%d %H:%M:%S", localtime()) . "\n";
print sort map {"$_\n"}
    uniq 
    map {ref $_ ? $_->[0] : $_}
    map {get_db_config($_, skip_pass => 1)->{host}}
    grep {$_ !~ $DONT_WATCH_RE} 
    @{get_db_childs('', recursive => 1)};
