#!/usr/bin/perl
use strict;
use warnings;

use my_inc '../..';

=head1 NAME

hash_data2_files.pl

=head1 DESCRIPTION

Скрипт используется для подсчета хэш-сумм статических файлов в data3/desktop.bundles/direct, data3/desktop.bundles/head.
Посчитанные хэш-суммы записываются в файлы data3/hashsums.json. Сами файлы с помощью правил
в direct-vhost.conf (конфиг nginx) сделаны доступными по адресам
'/data3/desktop.bundles/_direct.v-XXXX.ext'.

Пример запуска с параметрами:
./hash_data2_files.pl data3/desktop.bundles/direct data3/desktop.bundles/head -o data3/hashsums.json

=cut

use Direct::StaticFilesHash;
use ScriptHelper get_file_lock => undef, script_timer => undef;

my $HASHSUM_FILE_PATH = 'data3/hashsums.json';
extract_script_params(
    'o|output=s' => \$HASHSUM_FILE_PATH
);

my @STATIC_FILES_PATHS = @ARGV;
@STATIC_FILES_PATHS = ('data3/desktop.bundles/direct', 'data3/desktop.bundles/morda', 'data3/desktop.bundles/head', 'data3/touch.bundles/direct') unless @STATIC_FILES_PATHS;

Direct::StaticFilesHash::save_static_file_hashsums(\@STATIC_FILES_PATHS => $HASHSUM_FILE_PATH);

exit 0;

