#!/usr/bin/perl

use warnings;
use strict;

# $Id$
# script for rotate apache log
# author: Alexey Mazurov, possibly ;-)

if (@ARGV != 1 || $ARGV[0] !~ /^([a-z0-9\_\-\.]+)$/i) {
  die "Usage: $0 apache-name";
}
my $NAME = $ARGV[0];

# list of files to arc
my @ARCHED=(
		"/var/log/$NAME/access.log",
		"/var/log/$NAME/error.log",
        );

# list of files to empty
my @EMPTIED=(
		"/var/log/$NAME/ssl_engine.log",
        );

# list of files to copy to statbox (archived variants)
# directories to store these files to
my @STATBOXED=qw(
		);

# scp command - din't forget the space at the end!
my $SCP='/usr/bin/scp -2 -i /root/.ssh/statbox2 ';

# default owner of ARCDIR
my $OWNERUID=0; # root
my $OWNERGID=0; # root

my $TIMETOSLEEP = 10;

# usually yesterday
# my $ARCDATE=`date -d yesterday '+%Y%m%d'`;
my $ARCDATE=`date --date='12 hours ago' '+%Y%m%d'`;
chomp($ARCDATE);
my $NEWARCDATE=`date -d "2 day ago" '+%Y%m%d'`;
chomp($NEWARCDATE);

# appended to current log location
my $ARCSUFFIX='arc/';

# apache PIDFILE
my $PIDFILE="/var/run/$NAME.pid";

my $NEWFILEPATH;
my $OLDFILEPATH;
foreach my $FILEPATH (@ARCHED)
{
  next unless ( -e $FILEPATH );
  $NEWFILEPATH=$FILEPATH.".$ARCDATE";
  $OLDFILEPATH=$FILEPATH.".$NEWARCDATE";
  rename ($FILEPATH, $NEWFILEPATH) or print "Cannot rename $FILEPATH $NEWFILEPATH : $!\n";
  open (FILE, '>', $FILEPATH) or print "Cannot open $FILEPATH : $!\n";
  close (FILE);
  if (unlink($OLDFILEPATH) == 1) {
    #print "File $OLDFILEPATH deleted successfully.\n";
  } else {
    print "File was not deleted.\n";
  }
}

# restart apache
system "kill -USR1 `head -1 $PIDFILE`";
sleep $TIMETOSLEEP;

my $FILEDIR;
my $FILENAME;
my $ARCDIR;
foreach my $FILEPATH (@ARCHED)
{
  next unless ($FILEPATH =~ /(.*\/)(.*)$/ );
  $FILEDIR = $1;
  $FILENAME = $2;

  $NEWFILEPATH=$FILEPATH.".$ARCDATE";
  next unless (-e $NEWFILEPATH);
  
  $ARCDIR = $FILEDIR.$ARCSUFFIX;
  if ( ! -d $ARCDIR )
  {
    print "$ARCDIR not found, creating\n";
    mkdir ($ARCDIR,0755) or print "Cannot create $ARCDIR : $!\n";
    chown ($OWNERUID,$OWNERGID,$ARCDIR) or print "Cannot chown $OWNERUID:$OWNERGID $ARCDIR\n";
  }

  system "nice -5 gzip -c $NEWFILEPATH > $ARCDIR$FILENAME.$ARCDATE.'gz'";
  $NEWFILEPATH .= ".gz";
#  system "mv $NEWFILEPATH $ARCDIR$FILENAME.$ARCDATE.gz";
}

foreach my $FILEPATH (@EMPTIED)
{
  next unless ( -e $FILEPATH);
  open (FILE, '>', $FILEPATH) or print "Cannot open $FILEPATH : $!\n";
  close (FILE);
}

my $HOSTNAME = `hostname -s`; chomp ($HOSTNAME);
my $DESTNAME;
foreach my $FILEPATH (@STATBOXED)
{
  ($FILEPATH,$DESTNAME) = split(/\|/,$FILEPATH);
  next unless ($FILEPATH =~ /(.*\/)(.*)/ );
  $FILEDIR = $1;
  $FILENAME = $2;
  $NEWFILEPATH = $FILEDIR.$ARCSUFFIX.$FILENAME.'.'.$ARCDATE.'.gz';

  # print "$NEWFILEPATH\n";
  if (! -e $NEWFILEPATH)
  {
    print "$NEWFILEPATH does not exist, cannot scp\n";
    next;
  }
#  print 'Running: '.$SCP.$NEWFILEPATH.' '.$DESTNAME.'/'.$FILENAME.'.'.$HOSTNAME.'.'.$ARCDATE.'.gz'."\n";
#disabling log copying#  system $SCP.$NEWFILEPATH.' '.$DESTNAME.'/'.$FILENAME.'.'.$HOSTNAME.'.'.$ARCDATE.'.gz';
}
