#!/usr/bin/perl
use strict;
use warnings;

use Yandex::Shell;

use my_inc '../../..';
use Settings;

$Yandex::Shell::PRINT_COMMANDS = 1;

my $pidfile = "$Settings::ROOT/protected/run/intapi_coverage_starman.pid";
unlink $pidfile if -e $pidfile;

my @cmd = (
    'perl',
    '-MDevel::Cover',
    '/usr/bin/plackup',
    ( map { "-I$_" } @my_inc::MY_INC ),
    '--server' => 'Starman',
    '--port' => $Settings::BETA_PORT,
    '--host' => '127.0.0.7',
    "$Settings::ROOT/psgi/intapi.psgi",
    '--workers' => 1,
    '--pid' => $pidfile,
);

yash_system @cmd;
