#!/bin/sh

me=${0##*/}
me=${me%.*}

FILE="/var/www/ppc.yandex.ru/protected/monitor/server_errors.num"

[ ! -f $FILE ] && exit 0

VAL_WARN=10
VAL_CRIT=30

TIME_WARN=$((60*3600*1)) # One hour
TIME_CRIT=$((60*3600*2)) # Two hours

dt=`date +%s`

die() {
	echo "$1;$2"
	exit
}

[ -s $FILE ] || die 2 "File $FILE not found or empty"

stamp=`stat -c %Y $FILE`

[ $(($dt - $stamp)) -gt $TIME_CRIT ] && die 2 "File $FILE is old."
[ $(($dt - $stamp)) -gt $TIME_WARN ] && die 1 "File $FILE is old."

set -- `cat $FILE`

[ $# -ge 1 ] || die 2 "Check failed. See $FILE"

VAL=$1
shift
MES="$@"

[ $VAL -gt $VAL_CRIT ] && die 2 "$VAL errors $MES"
[ $VAL -gt $VAL_WARN ] && die 1 "$VAL errors $MES"

die 0 "Ok"
