#!/usr/bin/perl

=head1 DESCRIPTION

    Формирует файл с патронами из файлов, записанных скриптом tcp-proxy.pl.
    Пример запуска: ./make-conn-ammo.pl --conn-dir ./conn --ammo-file ./ammo.txt --host-header soap.direct.yandex.ru:80

=cut

use strict;
use warnings;
use utf8;

use Encode;
use JSON;
use Getopt::Long;

my($CONN_DIR, $HOST_HEADER, $AMMO_FILE) = ('./conn', 'soap.direct.yandex.ru:80', './ammo.txt');
GetOptions(
    'conn-dir=s' => \$CONN_DIR,
    'host-header=s' => \$HOST_HEADER,
    'ammo-file=s' => \$AMMO_FILE,
);

open T, '>:encoding(UTF-8)', $AMMO_FILE || die $!;

opendir D, $CONN_DIR || die $!;
NEXTFILE: for my $file(readdir D) {
    next if $file !~ /\.txt$/;

    open F, '<:encoding(UTF-8)', "$CONN_DIR/$file" || die $!;
    binmode F;
    my $request = <F>; # POST <url> <proto>
    next NEXTFILE unless $request =~ m#^(?:GET|POST) /(?:api|json-api)#;
    my $is_header = 1;
    my ($header, $data, $method) = ('','','');
    while (my $line = <F>) {
        if ($is_header) {
            if ($line eq "\n" || $line eq "\r\n") {
                $is_header = 0;
                $header .= "User-Agent: Tank/1.2.3\n";
                $header .= "Host: $HOST_HEADER\n";
            } elsif ($line =~ /^User-Agent: / or $line =~ /^Host: /) {
                next;
            } elsif ($line =~ /^SOAPAction: "API#([^"]+)"/) {
                $method = $1;
            } elsif ($line =~ /^[^\w]/) {
                # пропускаем продолжение предыдущего заголовка (сейчас многострочный только сертификат)
                next;
            } elsif ($line =~ /^X-/) {
                #next NEXTFILE;
                next;
            }
            $header .= $line;
        } else {
            $data .= $line;
        }
    }
    close F;

    if ($data && !$method) {
        $method = eval {
            my $decoded_data = decode_json $data;
            return $decoded_data->{method} if $decoded_data;
        };
    }

    $method = "UnMarked" unless $method;
    my $len = length(Encode::encode_utf8($request)) + length(Encode::encode_utf8($header))  + length(Encode::encode_utf8($data));
    my $d = "$len $method\n" . $request . $header . $data . "\n";

    print T $d;
}
closedir D || die $!;

close T;
