#!/usr/bin/perl

use my_inc "../..";


=c
    Простой скрипт, делающий рассылку писем с указанным текстом
        , с возможностью отправки картинок в тексте.

    Подробнее про отправку писем с картинками:
        http://search.cpan.org/~rjbs/MIME-Lite-3.024/lib/MIME/Lite.pm#Send_an_HTML_document..._with_images_included!
        
    Если кратко:
        1. В тексте добавляем: <img src="cid:my-picture" />.
        2. Тип письма: multipart/mixed.
        3. Делаем attach с указанным Id => 'my-picture', и Disposition => 'attachment'.
    
=cut

use warnings;
use strict;

use utf8;
use open ':std' => ':utf8';

use Settings;
use Yandex::DBTools;
use MailService;

use Encode;
use MIME::Lite;
use MIME::Base64 qw(encode_base64);

use Yandex::SendMail qw(call_sendmail);
use Yandex::IDN qw(is_valid_email);

#Список логинов, получателей писем
my $uss = get_all_sql(PPC(shard => 'all'), "
           SELECT t.*
             FROM (
                  SELECT u.email, u.fio, max(ifnull(mo.manager_office_id, 0) = 4) is_ukr, min(c.ManagerUID) man_uid
                    FROM campaigns c
                         join users u on u.uid = c.uid
                         left join users m on m.uid = c.ManagerUID
                         left join users_options mo on mo.uid = c.ManagerUID
                   WHERE
                     -- u.login in ('holodilnikru')
                     c.lastShowTime >= '2009-01-01'
                     AND ifnull(c.agencyuid, 0) = 0
                   GROUP BY email
                  ) t
            WHERE is_ukr = 0
               ");

print "Todo: ".scalar(@$uss)."\n";
foreach my $u (@$uss) {
    next if !$u->{email} || !is_valid_email($u->{email});
    print "$u->{email}\n";
    my $email = $u->{email};
    for my $email ('zhur@yandex-team.ru') {#, 'kiev@yandex-team.ru', 'mirage@yandex-team.ru', 'galeeva@yandex-team.ru') {
        send_mail_with_image($email, $u->{fio}, $u->{manager_fio});
    }
    last;
}

# !for test only!
#send_mail_with_image('zhur@yandex-team.ru', 'Журавлёв Сергей');

sub send_mail_with_image
{
    my ($to, $fio, $manager_fio) = @_;

    my $sign = 0 && $manager_fio ? "-- 
С наилучшими пожеланиями в Новом году,
$manager_fio
Отдел по работе с клиентами
www.yandex.ru" :
    "-- 
Команда Яндекса
www.yandex.ru";
    (my $html_sign = $sign) =~ s/\n/<br>\n/g;
    
    my $data_html = qq{<!DOCTYPE html PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN">
<html>
<head>
</head>
<body bgcolor="#ffffff" text="#000000">
<p><a href="http://www.advertising.yandex.ru/newyear.xml"><img border=0 src="cid:NY-2010.jpg" width="655" height="650" alt=""></a></p>
<p>$html_sign
</p>
</body>
</html>};
    
    my $data_text = qq{http://www.advertising.yandex.ru/newyear.xml

$sign
};
    
    my $from = "Яндекс.Директ";
    $from = $from ? '=?utf-8?B?'.encode_base64(Encode::encode('utf-8', $from), '').'?=' : '';
    $from = $from.'<support@direct.yandex.ru>';

    my $subj = 'Волшебное слово от Яндекса';
    $subj = '=?utf-8?B?'.encode_base64(Encode::encode('utf-8',$subj), '').'?=';

    my $msg = MIME::Lite->new( From    => $from,
                               To      => $to,
                               Subject => $subj,
                               Type    => 'multipart/related' );
    
    $msg->attach( Type => 'text/html; charset=utf-8',
                  Data => $data_html );

    # если html не поддерживается    
    #$msg->attach( Type => 'text/plain; charset=utf-8',
    #              Data => $data_text );
    
    $msg->attach( Type        => 'image/jpeg',
                  Path        => 'NY-2010.jpg',
#                  Filename    => 'NY-2010.jpg',
                  Id          => 'NY-2010.jpg',
#                  Disposition => 'inline' 
                  );
    
    #warn $msg->as_string();
    
    MailService::call_sendmail($msg->as_string());
}
