#!/usr/bin/perl

use my_inc "../..";



use Settings;
use Yandex::I18n;
use PdfTools;

use LaTeX::Driver;
use File::Slurp qw/write_file read_file/;
use Encode qw/encode/;
use Template;
use strict;
use warnings;
use utf8;

my $PDF_REPORT_DIR  = $Settings::ROOT.'/data/pdf_reports/';
my $TEX_TEMPLATE    = $PDF_REPORT_DIR.'english_pdf_appendix_for_reports.tex';
my $OUTPUT_PDF_FILE = $PDF_REPORT_DIR.'Appendix.pdf';

# Извлекаем текст, который будет составлять pdf документ.
# Так как LaTeX::Driver не работает с utf8, то перекодируем в cp1251.
# Хотя вроде бы в в английском языке не должно быть проблем с utf8, но переводим в русскую кодировку, на время отладки и перевода текста.
my $doc_text = encode('cp1251', makeTemplate());

my $output = '';

# Генерируем pdf файл
my $drv = LaTeX::Driver->new( source  => \$doc_text,
                        output  => \$output,
                        format  => 'pdf',
                        texinputs => $PDF_REPORT_DIR,
                    ) or die "ERROR 0:>>:$!\n";

$drv->run or die "ERROR 1:>>:$!\n";
$drv->stats or die "ERROR 2:>>:$!\n";

$output = PdfTools::set_pdf_cs_rgba( $output );
# Записываем его в файл
write_file($OUTPUT_PDF_FILE, $output);

exit;

sub makeTemplate {
    my $vars = { yalogo     =>  $PDF_REPORT_DIR.'yalogo_en.pdf',
                 yalogobig  =>  $PDF_REPORT_DIR.'yalogobig_en.pdf',
    };
    # Скрипт создан для того, чтобы переводить на английский язык один pdf документ, поэтому язык проставлен явно.
    Yandex::I18n::init_i18n('en', check_file => 1);

    my $config = {
        INCLUDE_PATH => '',  # or list ref
        INTERPOLATE  => 1,               # expand "$var" in plain text
        POST_CHOMP   => 1,               # cleanup whitespace
        START_TAG    => quotemeta('{$$'),
        END_TAG      => quotemeta('$$}'),
        PRE_DEFINE   => {
            iget                        => \&iget,
        },
    };

    my $template = Template->new($config);
    my $input = Encode::decode_utf8(read_file($TEX_TEMPLATE)) or die "Can`t open file [$TEX_TEMPLATE]\n";

    my $output='';
    # обработка шаблона 
    $template->process(\$input, $vars, \$output)
        || die $template->error();

    return $output;
}
