#!/usr/bin/perl

=head1 NAME

    make_yaml_settings.pl - генерация конфига Settings.pm в формате yaml

=head1 SINOPSIS

    # сгенерировать yaml и записать в файл
    make_yaml_settings.pl FILENAME

=cut

use strict;
use warnings;

use YAML::XS;
use Path::Tiny;

use Yandex::DBTools;

use my_inc "../..";

use Settings;

if (@ARGV) {
    die "Usage: $0\n";
}

my $YAML_FILE = path("$Settings::ROOT/etc/settings.yaml");

my %CONFIG = (
    ___note => "Generated by $0 at ".scalar(localtime),
    CONFIGURATION => $Settings::CONFIGURATION,
    BETA_HOST => $Settings::BETA_HOST,

    ROOT => $Settings::ROOT,
    LOCK_ROOT => $Settings::LOCK_ROOT,
    LOG_ROOT => $Settings::LOG_ROOT,
    DB_CONFIG_FILE => $Yandex::DBTools::CONFIG_FILE,
    SHARDS_NUM => $Settings::SHARDS_NUM,

    YT_CONF => $Settings::YT_CONF,
    YT_POOL_UPLOAD_DB => $Settings::YT_POOL_UPLOAD_DB,
    YT_POOL_PROCESS_LB => $Settings::YT_POOL_PROCESS_LB,
    );

$YAML_FILE->spew(YAML::XS::Dump(\%CONFIG));

