#!/usr/bin/perl

use my_inc "../..";


=head1 NAME

    mk_content_genres.pl

=head1 DESCRIPTION

    Генерация файла со списком Жанров и Категорий для танкера

=head1 RUNNING 

    При появлении новых жанров и категорий таргетинга нужно запускать этот скрипт на бете
    и закоммитить файл ./protected/data/translation/content_genres.trans,
    который затем подхватится танкером.

    До выкладки этого файла в продакшен будет продолжать приходить предупреждение
    на расслыку direct-maintenance

    Предполагается, что скрипт запускается с продакшен-конфигурацией, чтобы
    сложить в файл категории таргетинга из прода.
    Если почему-то нужны непродакшен-категории, можно запустить скрипт с ключом --force

    Если запустить скрипт с ключом --no-file результат будет выведен на экран и
    нигде не сохранен

=cut


use Direct::Modern;

use JSON;

use Settings;
use Yandex::DBTools;
use ScriptHelper;
use EnvTools;

use File::Slurp;

use open ':std' => ':utf8';

my $OUT_FILE = "$Settings::ROOT/protected/data/translation/content_genres.trans";

my ($no_file, $force);
extract_script_params(
    'no-file' => \$no_file,
    'force'   => \$force,
);

die "Чтобы подготовить названия жанров и категорий к коммиту, нужна продакшен-конфигурация (mk prod). 
Если ты знаешь, что делаешь, и тебе нужна разработческая конфигурация: запусти скрипт с ключом --force" if !is_production() && !$force;

my $content_genres = get_one_column_sql(PPCDICT,
 "SELECT DISTINCT(name) FROM crypta_goals WHERE crypta_goal_type IN ('content_genre', 'content_category') ORDER BY name");

my $content_genres_json = JSON->new->pretty->encode($content_genres);
if ($no_file) {
    print $content_genres_json;
} else {
    write_file($OUT_FILE, {binmode => ':utf8'}, $content_genres_json);
}
