#!/usr/bin/perl

use my_inc "../..";


=pod
    Формирование списка регионов для direct/direct,xls
=cut

use warnings;
use strict;

use Yandex::ReportsXLS;

use geo_regions;

use utf8;
use open ':std' => ':utf8';

my %F = %geo_regions::GEOREG;
my %ORDERS = (
    225 => 1, 166 => 2,
    3 => 1, 17 => 2, 26 => 3, 40 => 3, 59 => 4, 73 => 5, # Регионы России
    1 => 1, 213 => 1, # Моск. обл, Москва
    10174 => 1 # Ленинградская область
);

my @rows = get_data([grep {$F{$_}->{level} == 1} keys %F]);

my %COLORS = (
    1 => '47',
    2 => '47',
    3 => '42',
    4 => '43',
    5 => '41',
);

Yandex::ReportsXLS->new()->array2excel(
    [
     [''],
     [''],
     ['','','','',{data => "Регионы", format => {italic=>1, font => 'alial', size => 14}}],
     [''],
     [''],
     map {
         my $row = $_;
         my $color = $row->{type} == 2 && $row->{level} > 2 ? '43' : $COLORS{$row->{type}}||'white';
         ['', (map {{data => '', format => {bg_color => $color}}} 1..$_->{level}-1), {data => $_->{name}, format => {bg_color => $color}}]
     } @rows
    ],
    {
        output => "direct_new.xls",
        global_format => {border => 0},
        set_column => [
            {col1 => 0, col2 => 0, width => 9},
            {col1 => 1, col2 => 5, width => 3},
            {col1 => 6, col2 => 6, width => 20},
            ],
        merge_cells => [
            map {
                my $row = $rows[$_];
                +{row1 => 5+$_, row2 => 5+$_, col1 => $row->{level}, col2 => 6}
            } 0 .. $#rows
            ]
    }
);

sub get_data {
    my $g = shift;
    my @res;
    for my $r (sort {($ORDERS{$a}||9) <=> ($ORDERS{$b}||9) or $F{$a}->{name} cmp $F{$b}->{name}} @$g) {
        push @res, $F{$r}, get_data($F{$r}->{childs});
    }
    return @res;
}
