#!/usr/bin/perl

use my_inc "../..";


=head1 NAME

    mk_targeting_categories.pl

=head1 DESCRIPTION

    Генерация файла со списком категорий таргетинга для танкера

=head1 RUNNING 

    При появлении новых категорий таргетинга нужно запускать этот скрипт на бете
    и закоммитить файл ./protected/data/translation/targeting_categories.trans,
    который затем подхватится танкером.

    До выкладки этого файла в продакшен будет продолжать приходить предупреждение
    на расслыку direct-maintenance

    Предполагается, что скрипт запускается с продакшен-конфигурацией, чтобы
    сложить в файл категории таргетинга из прода.
    Если почему-то нужны непродакшен-категории, можно запустить скрипт с ключом --force

    Если запустить скрипт с ключом --no-file результат будет выведен на экран и
    нигде не сохранен

=cut


use warnings;
use strict;
use JSON;

use Settings;
use Yandex::DBTools;
use ScriptHelper;
use EnvTools;

use File::Slurp;

use utf8;
use open ':std' => ':utf8';

my $OUT_FILE = "$Settings::ROOT/protected/data/translation/targeting_categories.trans";

my ($no_file, $force);
extract_script_params(
    'no-file' => \$no_file,
    'force'   => \$force,
);

die "Чтобы подготовить причины отклонения к коммиту, нужна продакшен-конфигурация (mk prod). 
Если ты знаешь, что делаешь, и тебе нужна разработческая конфигурация: запусти скрипт с ключом --force" if !is_production() && !$force;

my $diags = get_one_column_sql(PPCDICT,
    "SELECT DISTINCT name
       FROM targeting_categories
      WHERE state != 'New'
      ORDER BY name");

my $categories_json = JSON->new->pretty->encode($diags);
if ($no_file) {
    print $categories_json;
} else {
    write_file($OUT_FILE, {binmode => ':utf8'}, $categories_json);
}
