#!/usr/bin/perl

use my_inc '../..';

=head1 NAME

    multicurrency-stat.pl

=head1 DESCRIPTION

    Собирает статистику по мультивалютности для https://st.yandex-team.ru/DIRECT-43620
    Работает с текущей конфигурацией, т.е. чтобы считать по проду надо переключать бету на продакшен-конфигурацию

=cut

use Direct::Modern;
use open ':std' => ':utf8';

use Yandex::DBTools;
use Settings;
use ScriptHelper;
use ShardingTools qw(ppc_shards);
use List::Util qw(sum);

my @shards = ppc_shards();

my $total_clients_cnt = sum 0, map { get_one_field_sql(PPC(shard => $_),
        'SELECT COUNT(DISTINCT u.ClientID) FROM users u INNER JOIN campaigns c ON u.uid = c.uid WHERE c.lastShowTime >= NOW() - INTERVAL 3 MONTH'
    ) // 0 } @shards;
print "* всего клиентов с показами за последние 3 месяца — $total_clients_cnt, из них:\n";


my $forcible_clients_cnt = sum 0, map { get_one_field_sql(PPC(shard => $_),
        'SELECT COUNT(*) FROM (SELECT cfcc.ClientID FROM client_firm_country_currency cfcc GROUP BY 1 HAVING COUNT(DISTINCT cfcc.country_region_id) = 1 AND COUNT(DISTINCT cfcc.currency) = 1) t WHERE EXISTS (SELECT 1 FROM users u INNER JOIN campaigns c ON u.uid = c.uid WHERE u.ClientID = t.ClientID AND c.lastShowTime >= NOW() - INTERVAL 3 MONTH)'
    ) // 0 } @shards;
print "  * с однозначной страной и валютой [только такие пригодны к принудительной конвертации] — $forcible_clients_cnt, из них:\n";


my $russian_forcible_clients_cnt = sum 0, map { get_one_field_sql(PPC(shard => $_),
        'SELECT COUNT(*) FROM (SELECT cfcc.ClientID FROM client_firm_country_currency cfcc GROUP BY 1 HAVING COUNT(DISTINCT cfcc.country_region_id) = 1 AND COUNT(DISTINCT cfcc.currency) = 1 AND COUNT(DISTINCT cfcc.currency) = 1 AND MAX(cfcc.country_region_id) = 225) t WHERE EXISTS (SELECT 1 FROM users u INNER JOIN campaigns c ON u.uid = c.uid WHERE u.ClientID = t.ClientID AND c.lastShowTime >= NOW() - INTERVAL 3 MONTH)'
    ) // 0 } @shards;
print "    * Россия — $russian_forcible_clients_cnt, из них:\n";


my $russian_converted_clients_cnt = sum 0, map { get_one_field_sql(PPC(shard => $_),
        'SELECT COUNT(*) FROM (SELECT cfcc.ClientID FROM currency_convert_queue q INNER JOIN client_firm_country_currency cfcc ON q.ClientID = cfcc.ClientID GROUP BY 1 HAVING COUNT(DISTINCT cfcc.country_region_id) = 1 AND COUNT(DISTINCT cfcc.currency) = 1 AND MAX(cfcc.country_region_id) = 225) t WHERE EXISTS (SELECT 1 FROM users u INNER JOIN campaigns c ON u.uid = c.uid WHERE u.ClientID = t.ClientID AND c.lastShowTime >= NOW() - INTERVAL 3 MONTH)'
    ) // 0 } @shards;
my $russian_converted_clients_percent = sprintf('%0.1f', 100 * $russian_converted_clients_cnt / $russian_forcible_clients_cnt);
print "      * сконвертировано или заказана конвертация — $russian_converted_clients_cnt [т.е. уже сконвертировано $russian_converted_clients_percent\%]\n";


my $russian_unconverted_clients_cnt = $russian_forcible_clients_cnt - $russian_converted_clients_cnt;
print "      * не ковертировалось — $russian_unconverted_clients_cnt, из них:\n";


my $russian_forcible_with_oferta_clients_cnt = sum 0, map { get_one_field_sql(PPC(shard => $_),
        'SELECT COUNT(*) FROM (SELECT cfcc.ClientID FROM client_firm_country_currency cfcc LEFT JOIN currency_convert_queue q ON cfcc.ClientID = q.ClientID INNER JOIN force_currency_convert fcc ON cfcc.ClientID = fcc.ClientID WHERE q.ClientID IS NULL GROUP BY 1 HAVING COUNT(DISTINCT cfcc.country_region_id) = 1 AND COUNT(DISTINCT cfcc.currency) = 1 AND MAX(cfcc.country_region_id) = 225) t'
    ) // 0 } @shards;
my $russian_waiting_for_oferta_clients_percent = sprintf('%0.1f', 100 - 100 * $russian_forcible_with_oferta_clients_cnt / $russian_forcible_clients_cnt);
print "        * с офертой — $russian_forcible_with_oferta_clients_cnt [т.е. осталось перевести, но нет отмашки — $russian_waiting_for_oferta_clients_percent\%]\n";


my $nonrussian_forcible_clients_cnt = sum 0, map { get_one_field_sql(PPC(shard => $_),
        'SELECT COUNT(*) FROM (SELECT cfcc.ClientID FROM client_firm_country_currency cfcc GROUP BY 1 HAVING COUNT(DISTINCT cfcc.country_region_id) = 1 AND COUNT(DISTINCT cfcc.currency) = 1 AND MAX(cfcc.country_region_id) NOT IN (225,983,159,149)) t WHERE EXISTS (SELECT 1 FROM users u INNER JOIN campaigns c ON u.uid = c.uid WHERE u.ClientID = t.ClientID AND c.lastShowTime >= NOW() - INTERVAL 3 MONTH)'
    ) // 0 } @shards;
print "    * со странами кроме России, Турции, Казахстана, Беларуси — $nonrussian_forcible_clients_cnt, из них:\n";


my $nonrussian_converted_clients_cnt = sum 0, map { get_one_field_sql(PPC(shard => $_),
    'SELECT COUNT(*) FROM (SELECT cfcc.ClientID FROM currency_convert_queue q INNER JOIN client_firm_country_currency cfcc ON q.ClientID = cfcc.ClientID GROUP BY 1 HAVING COUNT(DISTINCT cfcc.country_region_id) = 1 AND COUNT(DISTINCT cfcc.currency) = 1 AND MAX(cfcc.country_region_id) NOT IN (225,983,159,149)) t  WHERE EXISTS (SELECT 1 FROM users u INNER JOIN campaigns c ON u.uid = c.uid WHERE u.ClientID = t.ClientID AND c.lastShowTime >= NOW() - INTERVAL 3 MONTH)'
    ) // 0 } @shards;
my $nonrussian_converted_clients_percent = sprintf('%0.1f', 100 * $nonrussian_converted_clients_cnt / $nonrussian_forcible_clients_cnt);
print "      * сконвертировано или заказана конвертация — $nonrussian_converted_clients_cnt [т.е. уже сконвертировано $nonrussian_converted_clients_percent\%]\n";


my $nonrussian_unconverted_clients_cnt = $nonrussian_forcible_clients_cnt - $nonrussian_converted_clients_cnt;
print "      * не ковертировалось — $nonrussian_unconverted_clients_cnt, из них:\n";


my $nonrussian_forcible_with_oferta_clients_cnt = sum 0, map { get_one_field_sql(PPC(shard => $_),
        'SELECT COUNT(*) FROM (SELECT cfcc.ClientID FROM client_firm_country_currency cfcc LEFT JOIN currency_convert_queue q ON cfcc.ClientID = q.ClientID INNER JOIN force_currency_convert fcc ON cfcc.ClientID = fcc.ClientID WHERE q.ClientID IS NULL GROUP BY 1 HAVING COUNT(DISTINCT cfcc.country_region_id) = 1 AND COUNT(DISTINCT cfcc.currency) = 1 AND MAX(cfcc.country_region_id) NOT IN (225,983,159,149)) t'
    ) // 0 } @shards;
my $nonrussian_waiting_for_oferta_clients_cnt = sprintf('%0.1f', 100 - 100*$nonrussian_forcible_with_oferta_clients_cnt / $nonrussian_forcible_clients_cnt);
print "        * с офертой — $nonrussian_forcible_with_oferta_clients_cnt [т.е. осталось перевести, но нет отмашки — $nonrussian_waiting_for_oferta_clients_cnt%]\n";
