#!/usr/bin/perl
use strict;
use warnings;

=head1 METADATA

<crontab>
    time: */10 * * * *
    <switchman>
        group: scripts-test
    </switchman>
    package: conf-test-scripts
</crontab>

<crontab>
    env: SETTINGS_LOCAL_SUFFIX=DevTest
    time: 15 0-12 * * *
    package: conf-dev
</crontab>
<crontab>
    env: SETTINGS_LOCAL_SUFFIX=Dev7
    time: 30 0-12 * * *
    package: conf-dev
</crontab>

=head1 NAME

prepare_test_db.pl

=head1 DESCRIPTION

Скрипт подготовки данных в БД тестовой среды. Нужен для того, чтобы один раз после переливки
запустить несколько других скриптов; при повторном запуске ничего не делает.
Информация "скрипт уже отработал, ничего делать не нужно" хранится в ppc_properties.

=cut

use lib::abs;
use my_inc '../..';

use List::Util qw/max/;

use Yandex::DBShards;
use Yandex::DBTools;
use Yandex::Shell;

use Campaign;
use Client;
use Primitives;
use Property;
use Settings;
use ShardingTools;

my $UID_AT_DIRECT_MNGR_FULL = 50436777;

my $prop = Property->new('test_db_prepared');

exit 0 if $prop->get();

do_delete_from_table(PPCDICT, "reshard_queue", where => {status__not_in => ['done', 'error']});

# DIRECT-57027
do_update_table(PPCDICT, 'ppc_properties', { value => 0 }, where => { name => 'api_deprecated_error_show_rounds_count' });

# DIRECT-91795
do_update_table(PPCDICT, 'ppc_properties', { value => '["ZENO"]' }, where => { name => 'JOBS_RECOMMENDATIONS_MERGE_ENABLED_ON_CLUSTERS' });
do_update_table(PPCDICT, 'ppc_properties', { value => '["ZENO"]' }, where => { name => 'JOBS_RECOMMENDATIONS_TRANSFER_ENABLED_ON_CLUSTERS' });

# DIRECT-110972
do_update_table(PPCDICT, 'ppc_properties', { value => '-1' }, where => { name => 'clients_with_enabled_uzbek_language' });
# DIRECT-111111 OwO
do_insert_into_table(PPCDICT, 'ppc_properties', {value => 'true', name => 'calculate_implicit_cpa_max_bid_in_transport'}, ignore => 1);
do_insert_into_table(PPCDICT, 'ppc_properties', {value => '100', name => 'BS_NEW_STYLE_MULTIPLIERS_GEO_PERCENT'}, ignore => 1);

do_delete_from_table(PPCDICT, 'ppc_properties', where => { name => 'dss_certificate_serial_number' });

# DIRECT-109228, временно, до исправления автотестов в DIRECT-105504
do_delete_from_table(PPCDICT, 'ppc_properties', where => { name => 'return_campaign_spend_with_nds_in_api' });

# DIRECT-112538 удаляем пропертю, пока не закончится эксперимент в проде, см. DIRECT-104185
do_delete_from_table(PPCDICT, 'ppc_properties', where => { name => 'MIN_PAY_AB' });

# DIRECT-76662
do_sql(PPC(shard=>'all'), 'TRUNCATE TABLE mod_export_queue');
do_sql(PPC(shard=>'all'), 'TRUNCATE TABLE moderation_cmd_queue');
do_sql(PPC(shard=>'all'), 'TRUNCATE TABLE mod_resync_queue');
# DIRECT-90479
do_sql(PPC(shard=>'all'), 'TRUNCATE TABLE client_reminder_letters');

# DIRECT-91305
foreach_shard_parallel(shard => [ppc_shards()], sub {
    my $shard = shift;
    my $max_eventlog_id = get_one_field_sql(PPC(shard => $shard), "select max(id) from eventlog");
    return unless ($max_eventlog_id);
    do_update_table(PPCDICT, 'ppc_properties', {value => $max_eventlog_id}, where => {name => "ppcPushNotification_last_shard_$shard"});
});

# DIRECT-93452
my $max_domain_id = overshard_get_one_line({ group => '', max => 'max_domain_id' },
        PPC(shard => 'all'),
        "select max(domain_id) as max_domain_id from domains"
    )->{max_domain_id};
my $max_domain_id_ppcdict = get_one_field_sql(PPCDICT, "select max(domain_id) from domains_dict");
if ($max_domain_id > $max_domain_id_ppcdict) {
    do_sql(PPCDICT, "ALTER TABLE domains_dict AUTO_INCREMENT = $max_domain_id");
}

# DIRECT-116358
my $max_avatar_id = overshard_get_one_line({ group => '', max => 'max_avatar_id' },
        PPC(shard => 'all'),
        "select max(avatar_id) as max_avatar_id from clients_avatars"
    )->{max_avatar_id};
my $max_avatar_id_ppcdict = get_one_field_sql(PPCDICT, "select max(clients_avatars_id) from inc_clients_avatars_id");
if ($max_avatar_id > $max_avatar_id_ppcdict) {
    do_sql(PPCDICT, "ALTER TABLE inc_clients_avatars_id AUTO_INCREMENT = $max_avatar_id");
}

my $root = $Settings::ROOT;;
# DIRECT-87642
yash_system("$root/protected/maintenance/unblock_ynd_fixed_test_clients.pl");
yash_system("$root/protected/maintenance/create_test_campaigns.pl");
yash_system("$root/protected/maintenance/fill_currency_rates.pl");

#DIRECT-97214
my $targeting_type = 'rmp_interest';
my $parent_import_id = 1000000008;
my $child_import_id = 1000000009;
do_sql(PPCDICT, "INSERT IGNORE INTO targeting_categories (parent_category_id, import_id, targeting_type, original_name, name, state)
    VALUES (NULL, 1000000000, '$targeting_type', 'TEST_INTEREST_0', 'test interest 0', 'Submitted'),
           (NULL, 1000000001, '$targeting_type', 'TEST_INTEREST_1', 'test interest 1', 'Submitted'),
           (NULL, 1000000002, '$targeting_type', 'TEST_INTEREST_2', 'test interest 2', 'Submitted'),
           (NULL, 1000000003, '$targeting_type', 'TEST_INTEREST_3', 'test interest 3', 'Submitted'),
           (NULL, 1000000004, '$targeting_type', 'TEST_INTEREST_4', 'test interest 4', 'Submitted'),
           (NULL, 1000000005, '$targeting_type', 'TEST_INTEREST_5', 'test interest 5', 'Submitted'),
           (NULL, 1000000006, '$targeting_type', 'TEST_INTEREST_6', 'test interest 6', 'Submitted'),
           (NULL, 1000000007, '$targeting_type', 'TEST_INTEREST_7', 'test interest 7', 'Submitted'),
           (NULL, $parent_import_id, '$targeting_type', 'TEST_INTEREST_PARENT', 'test interest parent', 'Submitted'),
           (NULL, $child_import_id, '$targeting_type', 'TEST_INTEREST_CHILD', 'test interest child', 'Submitted')");

my $no_wallet_clientids = [
    58483942,  # at-direct-back-nowallet7 - DIRECT-99193
    64336118,  # at-direct-cmd-nowallet - DIRECT-102432
    15195583,  # at-direct-creative-construct4 - DIRECT-104394
    5883788,   # at-direct-backend-c - DIRECT-108898
    6865906,   # at-transport-tester-7 — DIRECT-111110
    21868847,  # at-client-with-shared-account - DIRECT-112538
    32074789,  # api-direct-byn-client3 - DIRECT-112538
    32144495,  # api-direct-byn-subclient3 - DIRECT-112538
    51838608,  # test-agency-rub-client-rub-1 - DIRECT-112538
    32142900,  # at-api-self-overdraft7 - DIRECT-112538
];
do_update_table(PPC(ClientID => $no_wallet_clientids), 'clients_options', {client_flags__smod => {create_without_wallet => 1}}, where => {ClientID => $no_wallet_clientids});
do_update_table(PPC(ClientID => $no_wallet_clientids), 'campaigns', {statusEmpty => 'Yes'}, where => {ClientID => $no_wallet_clientids, _OR => {wallet_cid__gt => 0, type => 'wallet'}});

# DIRECT-112538
# Разблокировка тестовых пользователей для прохождения автотестов API
my $uids_to_unblock = [
    $UID_AT_DIRECT_MNGR_FULL,
    115538251,  # at-direct-transfer-mngr
    101260409,  # at-direct-rep-client
    305103018,  # at-direct-rep-client-another
    241600810,  # api-subclient-shard2
    112635943,  # yndx-geomanager
    # DIRECT-114689: Проблемы с перловой регрессией после переналивки базы 26.02.2020
    167889479,  # at-direct-support
];
do_update_table(PPC(uid => $uids_to_unblock), 'users', {statusBlocked => 'No'}, where => {uid => $uids_to_unblock});

# DIRECT-102891
my @clientids_to_increase_concurrent_api_calls = (
    6865906, # at-transport-tester-7
    10111293,# at-transport-image-new
    3080088, # at-direct-super
);
Primitives::set_special_user_option($_, 'concurrent_calls', 30) for @clientids_to_increase_concurrent_api_calls;

my @remove_camps_from_bs_export = (
    # DIRECT-104956
    44713230, 44711195, 44711014
);
do_delete_from_table(PPC(cid => \@remove_camps_from_bs_export), 'bs_export_specials', where => { cid => SHARD_IDS });
do_delete_from_table(PPC(cid => \@remove_camps_from_bs_export), 'bs_export_queue', where => { cid => SHARD_IDS });

# DIRECT-110780
# Удаление лишних заявок на создание первых кампаний клиентов Яндекс-агенством
my $ya_agency_test_clientids = [
    34860963, # at-tester-yapromo
];
do_delete_from_table(PPC(shard=>'all'), 'yandex_agency_orders', where => { ClientID__not_in => $ya_agency_test_clientids});

my @clientids_to_accept_currency_convertation = (
    3348301, # DIRECT-114689: Проблемы с перловой регрессией после переналивки базы 26.02.2020
);
do_update_table(PPC(ClientID => \@clientids_to_accept_currency_convertation),
    'currency_convert_queue',
    {success_page_accepted => 1},
    where => {ClientID => SHARD_IDS, success_page_accepted => 0});

# DIRECT-153952: менеджеров объединяем в группу, чтобы потом добавлять доступ к клиентам на неё
my $DEFAULT_MANAGER_IDM_GROUP = 1000;
do_insert_into_table(PPCDICT, 'idm_groups', { idm_group_id => $DEFAULT_MANAGER_IDM_GROUP, role => 'manager' });

my @managers_client_ids_to_add_into_idm_group = (
    907767, # at-direct-mngr-full
    907740, # at-direct-tl-full
    907741, # at-direct-stl-full
);
for my $mngr_cl_id (@managers_client_ids_to_add_into_idm_group) {
    do_insert_into_table(PPC(ClientID => $mngr_cl_id), 'idm_groups_members', { ClientID => $mngr_cl_id, idm_group_id => $DEFAULT_MANAGER_IDM_GROUP });
}

# DIRECT-115459: в постналивочном скрипте брать логины на сервисирование
my @clientid_serviced_by_direct_mgr_full = (
    # DIRECT-114689: Проблемы с перловой регрессией после переналивки базы 26.02.2020
    7901693, # at-direct-b-copydyncamp
    5547676, # at-backend-minuswords
    51911026, # at-direct-searchbanners1
    9251924, # at-direct-banners-callouts-22
    24300268, # at-direct-copy-negative
    9161312, # at-direct-banners-callouts-23
    9162835, # at-direct-banners-callouts-24
    9158682, # at-direct-banners-callouts-21
    9537415, # at-direct-mediaplan-5
    8881522, # at-direct-mng-client3
    # DIRECT-112643: Разобраться почему рассервисируются клиенты у at-direct-mngr-full
    32424560, # at-camp-get-serv2
    4570847, # at-serv-campaigns
);
for my $cl (@clientid_serviced_by_direct_mgr_full) { 
    do_insert_into_table(PPC(ClientID => $cl), 'client_managers', {ClientID => $cl, manager_uid => $UID_AT_DIRECT_MNGR_FULL}, ignore => 1);
    my $client = get_client_data($cl, [qw/chief_uid work_currency/]);
    create_empty_camp(ClientID => $cl, client_chief_uid => $client->{chief_uid}, currency => $client->{work_currency}, statusEmpty => "No", client_email => 'prepare_test@db.pl');
    do_update_table(PPC(ClientID => $cl), 'campaigns', { ManagerUID => $UID_AT_DIRECT_MNGR_FULL }, where => { ClientID => $cl, ManagerUID__is_null => 1 });
    # Добавим доступ к этому клиенту для дефолтной тестовой группы менеджеров (DIRECT-153952)
    do_insert_into_table(PPC(ClientID => $cl), 'idm_group_roles', { subject_ClientID => $cl, idm_group_id => $DEFAULT_MANAGER_IDM_GROUP });
    do_update_table(PPC(ClientID => $cl), 'clients',
        { primary_manager_uid => $UID_AT_DIRECT_MNGR_FULL, primary_manager_set_by_idm => 1 },
        where => { ClientID => $cl });
}

my $four_digit_precision_feature_id = get_one_field_sql(PPCDICT, "SELECT feature_id FROM features WHERE feature_text_id = 'stat_4_digits_precision'");
do_insert_into_table(PPC(ClientID => 2292258), 'clients_features',
    {ClientID => 2292258, feature_id => $four_digit_precision_feature_id, is_enabled => 1}, on_duplicate_key_update => 1); # ic-rbt

$prop->set(1);
