#!/usr/bin/perl

use my_inc "../..";


=head1 NAME

    process_logvars.pl

=head1 DESCRIPTION

    Генерация описания данных, передаваемых в шаблоны

    Обрабатываем данные из logs/logvars/$block.$pid: $vars_json

    Результат пишем в директорию блока в файл $name.schema.json

=cut

use strict;
use warnings;

use File::Slurp;
use JSON;

use Settings;
use VarsSchema;

use open qw(:std :utf8);
use utf8;


my $logdir = VarsSchema::get_logdir();

opendir(my $dh, $logdir) or die "Can't open $logdir";
my @files = grep {-f "$logdir/$_"} readdir($dh);
closedir($dh);

my $data = {};
for my $file (@files) {
    my ($block) = $file =~ /^(.*)\.\d+$/;

    $data->{$block} ||= [];
    push @{$data->{$block}}, map {from_json $_} read_file("$logdir/$file", binmode => ':utf8', chomp => 1);
}

for my $block (keys %$data) {
    my $schema = VarsSchema::generalize($data->{$block});
    if (my $old_schema = VarsSchema::read_schema($block)) {
        VarsSchema::merge_descriptions($schema, $old_schema);
    }
    VarsSchema::write_schema($block, $schema);
    warn "Updated schema for $block\n";
}
