#!/usr/bin/perl

use my_inc "../..";


=head1

Скрипт для помощи в резолве конфликтов при слиянии веток переводов в танкере.

Использование:
    cat conflict | ./protected/maintenance/tanker-resolver.pl > conflict_resolved

https://wiki.yandex-team.ru/direkt/i18n/tanker-merge

Документация по API танкера: http://doc.yandex-team.ru/Tanker/api-reference/concepts/operations-branches.xml?ncrnd=751043#branches-merge

https://jira.yandex-team.ru/browse/DIRECT-26895

=cut

use warnings;
use strict;

use JSON qw/from_json to_json/;

# --------------------------------------------------------------------
sub main {
    my $data = from_json(join('', <STDIN>));

    my ($i, $resolved_count) = (0, 0);
    while (my ($key, $val) = each %$data) {

        # случай новой не переведенной фразы
        if ($val->{status}
            && $val->{status}->{a} eq 'requires_translation'
            && $val->{status}->{b} eq 'approved'
            && $val->{form}
            && length($val->{form}->{a}) == 0
            && length($val->{form}->{b}) > 0
            && ! $val->{status}->{resolved}
            && ! $val->{form}->{resolved}
           )
        {
            $val->{form}->{resolved} = $val->{form}->{b};
            $val->{status}->{resolved} = "b";
            $resolved_count++;
        }

        # случай если перевод не изменился, но был утвержден в бранче
        if ($val->{status}
            && ($val->{status}->{a} eq 'generated'
                || $val->{status}->{a} eq 'translated'
                || $val->{status}->{a} eq 'requires_translation'
               )
            && $val->{status}->{b} eq 'approved'
            && ! $val->{status}->{resolved}
           )
        {
            $val->{status}->{resolved} = "b";
            $resolved_count++;
        }

        # добавился контекст
        if ($val->{context}
            && length($val->{context}->{a}) == 0
            && length($val->{context}->{b}) > 0
            && ! $val->{context}->{resolved}
           )
        {
            $val->{context}->{resolved} = $val->{context}->{b};
            $resolved_count++;
        }

        # в транке удалили в бранче поменяли ИЛИ в транке поменяли в бранче удалили
        # оставляем транк
        if ($val->{a}
            && $val->{b}
            && ($val->{a} eq 'deleted' && $val->{b} eq 'modified'
                ||
                $val->{a} eq 'modified' && $val->{b} eq 'deleted'
               )
            && ! $val->{resolved}
           )
        {
            $val->{resolved} = "a";
            $resolved_count++;
        }

        # перевод поменялся и в транке и в бранче, берем из транка
        if ($val->{form}
            && length($val->{form}->{a}) > 0
            && length($val->{form}->{b}) > 0
            && ! $val->{form}->{resolved}
           )
        {
            $val->{form}->{resolved} = $val->{form}->{a};
            $resolved_count++;
        }

        # references - берем из транка
        if ($val->{references}
            && length($val->{references}->{a}) > 0
            && length($val->{references}->{b}) > 0
            && ! $val->{references}->{resolved}
           )
        {
            $val->{references}->{resolved} = $val->{references}->{a};
            $resolved_count++;
        }

        $i++;
    }

    print STDERR "Resolved $resolved_count of $i\n";
    print to_json($data, {pretty => 1});
}

# --------------------------------------------------------------------
main();
