#!/usr/bin/perl

use my_inc "../..";


=head1 METADATA

<crontab>
    time: */10 * * * *
    <switchman>
        group: scripts-test
    </switchman>
    package: conf-test-scripts
</crontab>

<crontab>
    env: SETTINGS_LOCAL_SUFFIX=DevTest
    time: */10 * * * *
    package: dev-scripts
</crontab>
<crontab>
    env: SETTINGS_LOCAL_SUFFIX=Dev7
    time: */10 * * * *
    package: dev-scripts
</crontab>

=head1 DESCRIPTION

    $Id$
    Тестовые базы Директа и Баланса обновляются в разное время.
    Чтобы баланс не выдавал ClientID, уже существующие в Директе,
    создаём кучу фэйковых клиентов

=cut

use warnings;
use strict;

use List::Util qw(max min);

use Yandex::Balance;
use Yandex::DBTools;
use Yandex::DBShards;

use lib::abs '..';

use Settings;
use EnvTools;
use Property;
use ScriptHelper;

my $MAX_CLIENTS = 100_000;

$log->out('START');

if (is_production() || is_sandbox()) {
    $log->die("This script can work only on any test configuration");
}

$log->out("start client id catch up");
eval {
    client_id_catch_up();
};
$log->warn($@) if $@;

$log->out("start order id catch up");
eval {

    service_order_id_catch_up();
};
$log->warn($@) if $@;

$log->out('FINISH');

=head2 service_order_id_catch_up

    Забираем из тестового Баланса информацию о максимальном номере заказа Директа
    И если он на 100_000 больше максимального в Директе - увеличиваем счетчик заказов в Директе

=cut

sub service_order_id_catch_up
{
    # синхронизуем cid's и номера заказов в тестовом Балансе
    my $max_cid = get_new_id('cid', ClientID => 0);
    $log->out("max direct cid = $max_cid");

    my $max_balance_cid;
    eval {
        # получаем максимальный номер заказа Директа в Балансе (на самом деле к максимальному они прибавляют 1_000_000)
        ($max_balance_cid) = Yandex::Balance::balance_test_get_max_orderserviceid(ServiceID => 7, BALANCE_XMLRPC_URL => $Yandex::Balance::TEST_BALANCE_XMLRPC_URL, timeout => 180);
        $log->out("max balance cid = $max_balance_cid");
    };

    $log->warn($@) if $@;

    # заглушка на случай ошибки при вызове метода Баланса
    $max_balance_cid ||= $max_cid;

    # сохраняем номер наименьший из номеров для автотестов. кампании с номерами меньше него должны быть в обоих базах.
    my $min_cid = min($max_cid, $max_balance_cid);
    $log->out("min cid from both services = $min_cid");

    # записывать LAST_PROD_CID_DIRECT_BALANCE необходимо только один раз после переналивки
    my $prop = Property->new("last_cid_from_prod_set");
    if (! $prop->get()) {
        # если база только переналилась, то записываем LAST_PROD_CID_DIRECT_BALANCE
        # необходимо для автотестов
        Property->new('LAST_PROD_CID_DIRECT_BALANCE')->set($min_cid);
        $prop->set(1);
    }

    # увеличиваем AUTO_INCREMENT в списке кампаний
    if ($max_cid - $max_balance_cid < 0) {
        my $new_max_cid = $max_balance_cid;
        $log->out("update cid to $new_max_cid");
        do_insert_into_table(PPCDICT, $Yandex::DBShards::SHARD_KEYS{cid}{table}, {cid => $new_max_cid, ClientID => 0});
    }
}

sub client_id_catch_up
{

    eval {
        my $max_database_client_id = max(@{get_one_column_sql(PPC(shard => 'all'), "SELECT ifnull(max(ClientID),0) from users") || []});
        my ($max_balance_client_id) = Yandex::Balance::balance_test_get_max_clientid(BALANCE_XMLRPC_URL => $Yandex::Balance::TEST_BALANCE_XMLRPC_URL);

        $log->out( { database => $max_database_client_id, balance => $max_balance_client_id } );

        if ( $max_database_client_id > $max_balance_client_id ) {
            my ($new_max_balance_client_id) = Yandex::Balance::balance_test_update_client_id(
                NewMaxClientID => $max_database_client_id, BALANCE_XMLRPC_URL => $Yandex::Balance::TEST_BALANCE_XMLRPC_URL);
            $log->out( { balance_new => $new_max_balance_client_id } );
        } else {
            $log->out('Balance is already caught up');
        }
    };

    $log->die($@) if $@;
}
