#!/usr/bin/env perl

use my_inc "../..";

=head1 NAME

test_mds_clean

=head1 SYNOPSIS

./test_mds_clean.pl

# удалить файлы только определённыx типов
./test_mds_clean.pl --type api_forecast --type api_wordstat

# удалить файлы старше суток (86400 секунд)
./test_mds_clean.pl --min-age 86400

# удалять пачками по 5000 штук
./test_mds_clean.pl --one-iteration-limit 5000

=head1 DESCRIPTION

Скрипт экстренного удаления всего известного из MDS, чему больше определённого времени.

=cut

use Direct::Modern;
use Direct::Storage;
use Direct::Storage::Types;
use ScriptHelper get_file_lock => undef;
use Settings;

my $TIME = 12 * 3600;

# сколько файлов можно удалить за одну итерацию
my $FILE_DELETION_LIMIT = 10_000;

my @FILE_TYPES;

extract_script_params(
    '--type=s' => \@FILE_TYPES,
    '--one-iteration-limit=i' => \$FILE_DELETION_LIMIT,
    '--min-age=i' => \$TIME,
);
if (!@FILE_TYPES) {
    @FILE_TYPES = sort keys %Direct::Storage::Types::MDS_FILE_TYPES;
}

$log->out('START');
my $storage = Direct::Storage->new();

foreach my $file_type (@FILE_TYPES) {
    if (mds_check_type_trait($file_type, 'empty_client_id')) {
        $log->out("removing old $file_type files from ppcdict");
        for (my $deleted_files = [1]; scalar(@$deleted_files);) {
            $deleted_files = $storage->remove_old_files(0, $file_type, $TIME,
                limit => $FILE_DELETION_LIMIT,
                storage_host => $Yandex::MDS::MDS_GET_HOST
            );
            $log->out({deleted_files => scalar(@$deleted_files)});
        }
    } else {
        foreach my $SHARD (1 .. $Settings::SHARDS_NUM) {
            $log->out("removing old $file_type files from shard $SHARD");
            for (my $deleted_files = [1]; scalar(@$deleted_files);) {
                $deleted_files = $storage->remove_old_files($SHARD, $file_type, $TIME,
                    limit => $FILE_DELETION_LIMIT,
                    storage_host => $Yandex::MDS::MDS_GET_HOST
                );
                $log->out({deleted_files => scalar(@$deleted_files)});
            }
        }
    }
}

$log->out('FINISH');
