#!/usr/bin/perl

use my_inc "../..";


=head1 NAME

unblock_ynd_fixed_test_clients.pl - разблокировка тестовых пользователей

=head1 DESCRIPTION

    Скрипт разблокирует тестовых клиентов в y. e. по списку в тестовых базах.
    Клиентам из списка снимаем флаг cant_unblock и ставим statusBlocked = 'No'

    Скрипт должен использоваться ТОЛЬКО в тестовой среде.

=cut


use Direct::Modern;

use Yandex::DBTools;

use EnvTools;
use ScriptHelper;
use Settings;

my $uid2user_data = {
    101216279 => { ClientID => 1370987, login => 'api-subclient' },
    222123627 => { ClientID => 3060282, login => 'at-agency-transfer' },
    222135364 => { ClientID => 3060588, login => 'at-client-tm1' },
    222135549 => { ClientID => 3060592, login => 'at-client-tm2' },
    229619766 => { ClientID => 3297566, login => 'at-client-tm6' },
    131560570 => { ClientID => 1769588, login => 'at-direct-ag-another' },
    167883729 => { ClientID => 2166991, login => 'at-direct-ag-client' },
     50436888 => { ClientID =>  907781, login => 'at-direct-ag-full' },
    305111636 => { ClientID =>  907781, login => 'at-direct-ag-rep-another' },
    142369659 => { ClientID => 1935307, login => 'at-direct-api-another' },
     64270283 => { ClientID => 1016416, login => 'at-direct-api-test' },
    223670751 => { ClientID => 3112724, login => 'at-retargeting' },
    131630732 => { ClientID => 1893015, login => 'maria-baibik' },
     50321709 => { ClientID =>  910609, login => 'at-direct-client-ful' },
    167883921 => { ClientID => 2167059, login => 'at-direct-mngr-client' },
    124300925 => { ClientID => 1618961, login => 'moris-travel' },
    118893932 => { ClientID => 1541616, login => 'transfer-ag-cl-2' },
    253223306 => { ClientID => 4393401, login => 'account-subclient-shard2-2' },
    303592463 => { ClientID => 6530334, login => 'at-direct-b-with-ag-ret' },
};

#..............................................................................
sub main
{
    die "$0 in production!" if is_production();

    $log->out("start");

    for my $uid (keys %$uid2user_data) {
        my $client_id = $uid2user_data->{$uid}->{ClientID};
        my $login = $uid2user_data->{$uid}->{login};
        my $guard = $log->msg_prefix_guard("[login=$login, uid=$uid, ClientID=$client_id]");
        do_update_table(PPC(ClientID => $client_id), 'clients_options', {client_flags__smod => {cant_unblock => 0}}, where => {ClientID => $client_id});
        do_update_table(PPC(ClientID => $client_id), 'users', {statusBlocked => 'No'}, where => {uid => $uid});
        $log->out('unblock done');
    }

    $log->out("finish");
}

#..............................................................................
main();
