package mediastatXLS;
## no critic (TestingAndDebugging::RequireUseWarnings)

# $Id$
# Вывод результатов прогноза в формате XLS
# Автор: Сергей Журавлёв

#print STDERR "  PATCH:COMMENT:>>:The patch does work!\n";
#print STDERR " \@INC is ". join("\n", map {"  >>:$_"} @INC),"\n";

use strict;
use vars qw($VERSION @ISA @EXPORT @EXPORT_OK);
require Exporter;
use Spreadsheet::WriteExcel;
use utf8;

use Yandex::I18n;

use MediaplanOptions;


# set the version for version checking
$VERSION     = 1.00;
@ISA         = qw(Exporter);
@EXPORT_OK = @EXPORT = qw( mediastat_detail_xls mediastat_xls );

{
    my @stat_ranges = (
        [ before_1_week => iget_noop('1 неделя ДО:') ],
        [ after_1_week  => iget_noop('1 неделя ПОСЛЕ:') ],
        [ before_2_week => iget_noop('2 недели ДО:') ],
        [ after_2_week  => iget_noop('2 недели ПОСЛЕ:') ],
        [ before_4_week => iget_noop('4 недели ДО:') ],
        [ after_4_week  => iget_noop('4 недели ПОСЛЕ:') ],
    );

    my %stat_field = (
        shows       => [ iget_noop('Показы') ],
        clicks      => [ iget_noop('Клики') ],
        ctr         => [ iget_noop('CTR'), num_format => '0.00%' ],
        sum         => [ iget_noop('Деньги'), num_format => '0.00' ],
        days        => [ iget_noop('Активных дней') ],
        avg_sum     => [ iget_noop('Avg.daily cost'), num_format => '0.00' ],
        avg_clicks  => [ iget_noop('Avg.daily clicks'), num_format => '0.00' ],
    );

# Вывод прогноза в виде XLS
sub mediastat_detail_xls($$$)
{
    my ( $vars, $login_rights, $out ) = @_;

    $Carp::Verbose = 1;

    # Создаём таблицу
    my $work = Spreadsheet::WriteExcel->new($out);
    my $list = $work->addworksheet("Статистика");

    my $is_manager_stat = $vars->{type_stat} eq 'managers';

    # Создаём форматы
    my $f_header = $work->addformat( size=>8, bold => 1, valign => 'vcenter', align => 'center', border => 1, fg_color => 22, text_wrap => 1, pattern => 1 );
    my $fcnt = $work->addformat( size=>8, align => 'center', valign => 'vcenter', top=>1, bottom=>1 );

    my $target_str =
        $is_manager_stat && $vars->{m_info} ? "Менеджер: ".$vars->{m_info}{fio} .' (' .$vars->{m_info}{login}.')' :
        $is_manager_stat                    ? "Все менеджеры" :
        $vars->{m_info}                     ? "Медиапланер: ".$vars->{m_info}{fio}.' ('.$vars->{m_info}{login}.')' :
                                              "Все медиапланеры";
    $list->write(1, 0, $target_str, $work->addformat( size=>12, bold=>1));

    $list->write(2, 0,  'статистика за '.
                        (($vars->{FORM}{date_from} or $vars->{FORM}{date_to})?'':'весь ').
                        'период'.
                        ( $vars->{FORM}{date_from} ? ' с '.$vars->{FORM}{date_from} : '').
                        ( $vars->{FORM}{date_to}   ?' по '.$vars->{FORM}{date_to}   : '')
                                    , $work->addformat( size=>12, bold=>1 ));

    my %accept_status = (
        Yes => iget('принято'),
        No => iget('в ожидании'),
        Rejected => iget('отклонено'),
    );

    my @columns = (
        [ media_login => iget('Медиапланер'), width => 30, format => {align=>'left'}, modify => sub {
                my ($login, $mplan) = @_;
                $login ? "$mplan->{media_fio} ($login)" : $login;
            }],
        [ login => iget('Логин клиента'), width => 15, format => {align=>'left'} ],
        [ cid => iget('№ кампании') ],
        [ accepted => iget('Статус'), modify => sub {$accept_status{shift()}} ],
        [ create_time => iget('Дата создания') ],
        [ accept_time => iget('Дата принятия/отклонения') ],
        [ num_banners_added => iget('Добавлено баннеров') ],
        [ num_phrases_added => iget('Добавлено фраз') ],
        [ reject_reason => iget('Причина отклонения'), width => 20, modify => sub {
                my ($reason_code, $mplan) = @_;
                my $result = iget($MediaplanOptions::REJECT_REASON{$reason_code});
                $result .= " ($mplan->{comment})"  if $reason_code eq 'other' && $mplan->{comment};
                return $result;
            } ],

        (map {
            my $r = $_->[0];
            map {
                my ($t, %f) = @{$stat_field{$_}};
                ["${_}_$r" => iget($t), width => 6, (%f ? (format => \%f) : ())]
            } qw/shows clicks ctr sum days avg_sum avg_clicks/
        } @stat_ranges),
    );


    #   Шапка таблицы
    my $row_cnt = 4;
    my $col = 9;

    for my $range (@stat_ranges) {
        my ($key, $title) = @$range;
        $list->merge_cells($row_cnt, $col, $row_cnt, $col+6);
        $list->write($row_cnt, $col, iget($title), $f_header);
        $col += 7;
    }

    $row_cnt ++;
    $col = 0;

    for my $column (@columns) {
        my ($key, $title, %opt) = @$column;
        $list->set_column($col, $col, $opt{width} || 12);
        $list->write($row_cnt, $col++, $title, $f_header);
    }

    $row_cnt++;

    #   Таблица
    for my $mpid (@{$vars->{mplans_sort}}) {
        my $mplan = $vars->{mplans}{$mpid};
        my $col=0;

        for my $column (@columns) {
            my ($key, $title, %opt) = @$column;
            my $format = $opt{format} ? new_format($work, $fcnt, %{$opt{format}}) : $fcnt;
            my $value = $mplan->{$key};
            $value = $opt{modify}->($value, $mplan)  if $opt{modify};
            $list->write($row_cnt, $col++, $value || '-' , $format);
        }

        $row_cnt++;
    }

    return;
}

# Вывод прогноза в виде XLS
sub mediastat_xls($$$)
{
    my ( $vars, $login_rights, $out ) = @_;

    $Carp::Verbose = 1;

    # Создаём таблицу
    my $work = Spreadsheet::WriteExcel->new($out);
    my $list = $work->addworksheet("Статистика");

    # Создаём форматы
    $work->set_custom_color(40, "#DDDDDD");
    my $f_header = $work->addformat( size=>8, bold => 1, valign => 'vcenter', align => 'center', border => 1, fg_color => 22, text_wrap => 1, pattern => 1 );
    my $fcnt = $work->addformat( size=>8, align => 'center', valign => 'vcenter', top=>1, bottom=>1 );
    my $gfcnt = $work->addformat( size=>8, align => 'center', fg_color => 40, valign => 'vcenter', top=>1, bottom=>1 );

#    if ( not defined $vars->{FORM}{type_stat} or $vars->{FORM}{type_stat} eq 'managers' ) {
#        $list->write(1, 0, "Менеджер: ".$vars->{m_info}{FIO} .' (' .$vars->{m_info}{login}.')', $work->addformat( size=>12, bold=>1));
#    } else {
#        $list->write(1, 0, "Медиапланер: ".$vars->{m_info}{FIO}.' ('.$vars->{m_info}{login}.')', $work->addformat( size=>12, bold=>1));
#    }
    $list->write(1, 0, "Статистика по медиапланированию для " . ($vars->{type_stat} eq 'managers' ? 'менеджеров': 'медиапланеров') . ($vars->{REQUEST_TYPE_VALUE} ? ", тип заявки: " . $vars->{REQUEST_TYPE_VALUE}: ''), $work->addformat( size=>12, bold=>1));
    $list->write(2, 0,  'статистика за '.
                        (($vars->{from} or $vars->{to})?'':'весь ').
                        'период'.
                        ( $vars->{from} ? ' с '. join('-', (map {$vars->{from}->{$_}} qw(day month year))) : '').
                        ( $vars->{to}   ?' по '. join('-', (map {$vars->{to}->{$_}} qw(day month year)))   : '')
                                    , $work->addformat( size=>12, bold=>1 ));


    my @columns = (
        [ finished_cnt => iget('Завершено медиапланов') ],
        [ accepted_cnt => iget('Принято') ],
        [ accept_ratio => iget('% принятия'), format => { num_format => '0.0%'} ],
        [ num_banners_added => iget('Добавлено баннеров в принятых') ],
        [ num_phrases_added => iget('Добавлено фраз в принятых') ],
        [ rejected_cnt => iget('Всего отклонено') ],

        [ rejected_too_expensive_cnt => iget('Отклонено ("Дорого")') ],
        [ rejected_bad_texts_cnt => iget('Отклонено ("Тексты")') ],
        [ rejected_bad_keywords_cnt => iget('Отклонено ("Фразы")') ],
        [ rejected_weird_intraface_cnt => iget('Отклонено ("Как принять?")') ],
        [ rejected_have_questions_cnt => iget('Отклонено ("Есть вопросы")') ],
        [ rejected_dont_need_cnt => iget('Отклонено ("И так хорошо")') ],
        [ rejected_do_myself_cnt => iget('Отклонено ("Хочу сам")') ],
        [ rejected_other_cnt => iget('Отклонено ("Другое")') ],

        (map {
            my $r = $_->[0];
            map {
                my ($t, %f) = @{$stat_field{$_}};
                ["${_}_$r" => iget($t), (%f ? (format => \%f) : ())]
            } qw/shows clicks ctr sum days avg_sum avg_clicks/
        } @stat_ranges),
    );


    #   Шапка таблицы
    my $row_cnt = 4;
    my $col = 15;

    for my $range (@stat_ranges) {
        my ($key, $title) = @$range;
        $list->merge_cells($row_cnt, $col, $row_cnt, $col+6);
        $list->write($row_cnt, $col, iget($title), $f_header);
        $col += 7;
    }

    $row_cnt ++;
    $col = 0;

    if ( $vars->{type_stat} eq 'managers' ) {
        $list->set_column($col, $col,  30);   $list->write($row_cnt, $col++, 'Менеджер', $f_header);
    } else {
        $list->set_column($col, $col,  30);   $list->write($row_cnt, $col++, 'Медиапланер', $f_header);
    }

    for my $column (@columns) {
        my ($key, $title) = @$column;
        $list->set_column($col, $col,  15);
        $list->write($row_cnt, $col++, $title, $f_header);
    }

    $row_cnt++;

    my $cnt_t = 0;
    if ( $vars->{type_stat} eq 'managers' ) {
        for my $tuid (@{$vars->{teams_sort}}) {
            next if ($vars->{user}{$tuid}{hidden}||'') eq 'Yes' and not $vars->{FORM}{show_hidden};

            my $cnt = 0;
            $cnt_t++;

            my $col=0;

            if ( $tuid eq 'none' ) {
                $list->write($row_cnt, $col++, iget('Менеджеры без тимлидера:'), $gfcnt);
            } else {
                $list->write($row_cnt, $col++, $vars->{user}{$tuid}{fio}. ' ('.$vars->{user}{$tuid}{login}.'):', new_format($work, $gfcnt, align=>'left' ));
            }

            for my $column (@columns) {
                my ($key, $title, %opt) = @$column;
                my $format = $opt{format} ? new_format($work, $gfcnt, %{$opt{format}}) : $gfcnt;
                $list->write($row_cnt, $col++, $vars->{user}{$tuid}{'stat'}{$key} || '-' , $format);
            }

            $row_cnt++;

            my $count_muid = 0;
            for my $muid (@{$vars->{teams}{$tuid}}) {
                next unless defined $vars->{user}{$muid}{login};
                next if ($vars->{user}{$muid}{hidden}||'') eq 'Yes' and not $vars->{FORM}{show_hidden};

                $count_muid++;
                $cnt++;

                my $col=0;
                $list->write($row_cnt, $col++, $vars->{user}{$muid}{fio}. ' ('.$vars->{user}{$muid}{login}.'):', new_format($work, $fcnt, align=>'left' ));
                
                for my $column (@columns) {
                    my ($key, $title, %opt) = @$column;
                    my $format = $opt{format} ? new_format($work, $fcnt, %{$opt{format}}) : $fcnt;
                    $list->write($row_cnt, $col++, $vars->{user}{$muid}{'stat'}{$key} || '-' , $format);
                }

                $row_cnt++;
            } #muid

            if ( $count_muid > 0 ) {
                my $col=0;
                $list->write($row_cnt, $col++, iget('Итого:'), new_format($work, $gfcnt, align=>'left' ));
                                
                for my $column (@columns) {
                    my ($key, $title, %opt) = @$column;
                    my $val = $vars->{user}{$tuid}{gstat}{$key};
                    $val = '-' if $opt{skip_totals};

                    my $format = $opt{format} ? new_format($work, $gfcnt, %{$opt{format}}) : $gfcnt;
                    $list->write($row_cnt, $col++, $val || '-' , $format);
                }
                $row_cnt++;
            }
            $row_cnt++;
        } #tuid %]
    } elsif ( $vars->{type_stat} eq 'mediaplanners' ) {
        for my $muid (@{$vars->{user_sort}}) {
            next if ($vars->{user}{$muid}{hidden}||'') eq 'Yes' and not $vars->{FORM}{show_hidden};
            $cnt_t++;

            my $col=0;
            $list->write($row_cnt, $col++, $vars->{user}{$muid}{fio}. ' ('.$vars->{user}{$muid}{login}.'):', new_format($work, $fcnt, align=>'left' ));
            
            for my $column (@columns) {
                my ($key, $title, %opt) = @$column;
                my $format = $opt{format} ? new_format($work, $gfcnt, %{$opt{format}}) : $gfcnt;
                $list->write($row_cnt, $col++, $vars->{user}{$muid}{'stat'}{$key} || '-' , $format);
            }

            $row_cnt++;

        }
    } #type_stat %]
  
    if ( $cnt_t > 1 ) {
        my $col=0;
                
        $list->write($row_cnt, $col++, 'Итого:', new_format($work, $gfcnt, align=>'left', bold => 1 ));

        for my $column (@columns) {
            my ($key, $title, %opt) = @$column;

            my $val = $vars->{gstat}{$key};
            $val = '-' if $opt{skip_totals};

            my $format = new_format($work, $gfcnt, %{$opt{format} || {}}, bold => 1);
            $list->write($row_cnt, $col++, $val || 0 , $format);
        }

        $row_cnt++;
    }
}
}

sub new_format {
    my ( $work, $fmt, %props ) = @_;
    my $f = $work->addformat();
    $f->copy( $fmt );
    $f->set_properties( %props );
    return $f;
}

# по номеру получить букву
sub xl {
    return chr( ord('A') + $_[0] );
}

1;
