#!/usr/bin/perl

use my_inc "..";

=head1 METADATA

<crontab>
    time: 22 3 * * *
    <switchman>
        group: scripts-other
    </switchman>
    package: scripts-switchman
</crontab>
<juggler>
    host:   checks_auto.direct.yandex.ru
    ttl: 2d3h
    tag: direct_group_internal_systems
</juggler>

=cut

=head1 NAME

    metricaFetchMobileInterests.pl

=head1 DESCRIPTION

    Заполучить из метрики все цели со специального счетчика и вставить в таблицу
    targeting_categories ppcdict те из них, которые там отсутствуют

=cut

use Direct::Modern;

use Yandex::DBTools;
use Yandex::Shell;
use Yandex::SendMail qw/send_alert/;

use MetrikaCounters;
use ScriptHelper 'Yandex::Log' => 'messages';

use Settings;

use Text::Diff;
use File::Slurp;
use List::Util qw/max/;

# workaround for: Can't call method "_put_session" on an undefined value at /usr/lib/perl5/AnyEvent/Handle.pm
# it's a race condition in the object destroying order
use Carp::Always;

# Номер счетчика Метрики, цели которого используются как категории таргетинга
# с типом targeting_type = "rmp_interest"
my $INTERESTS_COUNTER_NUM = 38461950;
my $TARGETING_TYPE = 'rmp_interest';
# Адрес для писем о необходимости переводов
my $BROADCAST_EMAIL = 'direct-maintenance@yandex-team.ru';

$log->out("START");

$log->out("Fetching all goals from counter $INTERESTS_COUNTER_NUM");
my $metrica_goals = MetrikaCounters::download_counter_goals([$INTERESTS_COUNTER_NUM])->{$INTERESTS_COUNTER_NUM};
$log->out("Got " . scalar(@$metrica_goals) . " goals");

$log->out("Fetching existing targeting categories for type '$TARGETING_TYPE' from database");
my $db_goals = get_hash_sql(PPCDICT, "SELECT import_id, category_id FROM targeting_categories WHERE targeting_type = ?", $TARGETING_TYPE);

my @goals_to_insert;

for my $goal (@$metrica_goals) {
    next if exists $db_goals->{$goal->{goal_id}};

    my $goal_to_insert = [
        $goal->goal_id,     # import_id,
        $TARGETING_TYPE,    # targeting_type,
        $goal->goal_name,   # original_name,
        $goal->goal_name,   # name,
    ];
    push @goals_to_insert, $goal_to_insert;
}

my $new_goals_count = scalar @goals_to_insert;
if (@goals_to_insert) {
    $log->out("Inserting $new_goals_count new goals into targeting_categories table");
    my $cnt = do_mass_insert_sql(PPCDICT,
        "insert into targeting_categories (import_id, targeting_type, original_name, name) values %s",
        \@goals_to_insert
    );
    $log->out("Succesfully inserted $cnt entries into targeting_categories table");
} else {
    $log->out("Nothing new to add to DB");
}

$log->out("Checking if we need to translate something new");
my $categories_file = "$Settings::ROOT/protected/data/translation/targeting_categories.trans";
my $new_categories_file = yash_qx("$Settings::ROOT/protected/maintenance/mk_targeting_categories.pl --no-file --force");
my $old_categories_file = read_file($categories_file);
my $diff = diff(\$old_categories_file, \$new_categories_file);

utf8::decode($diff);

# в случае наличия непереведенных причин отклонения, пишем письмо в рассылку
if ($diff) {
    $log->out("Sending diff alert to $BROADCAST_EMAIL");
    my $text = <<TEXT;
    Добавлены новые категории таргетинга.
    Для их перевода необходимо подготовить бету с продакшен-базой, запустить генерацию и закоммитить файл с текстами:
    mk conf_prod
    ./protected/maintenance/mk_targeting_categories.pl
    commit protected/data/translation/targeting_categories.trans
    mk conf_devtest
TEXT

    $text .= "===$categories_file\n--- file\n+++ DB\n$diff";
    send_alert($text , 'New unsynced targeting categories', $BROADCAST_EMAIL);
}

$log->out("Writing juggler data");
if ($diff) {
    my $msg = "Found untranslated targeting categories";
    juggler_crit(description => $msg);
    $log->out($msg);
} elsif (!scalar(@$metrica_goals)) {
    my $msg = "Got no goals for counter $INTERESTS_COUNTER_NUM from Metrica";
    juggler_crit(description => $msg);
    $log->out($msg);
} else {
    juggler_ok();
}

$log->out("FINISH");
