#!/usr/bin/perl

use my_inc "..";

=encoding utf8

=head1 METADATA

<crontab>
    params_postfix: 2>&1 | tail -1000
    time: */3 * * * *
    sharded: 1
    <switchman>
        group: scripts-other
        <leases>
            mem: 220
        </leases>
    </switchman>
    package: scripts-switchman
</crontab>
<juggler>
    host:       checks.direct.yandex.ru
    sharded:    1
    ttl:        30m
    tag: direct_group_internal_systems
    <notification>
        template: on_status_change
        status: CRIT
        status: OK
        method: telegram
        login: DISMonitoring
    </notification>
</juggler>

<crontab>
    params_postfix: 2>&1 | tail -1000
    time: 2-59/5 * * * *
    sharded: 1
    flock: 1
    <switchman>
        group: scripts-test
    </switchman>
    package: conf-test-scripts
</crontab>

=cut

=head1 NAME

moderateExportMaster.pl - скрипт, который обрабатывает очередь ленивой перемодерации

=head1 DESCRIPTION

    Опции:
    --help - справка
    --once - отработать только одну итерацию
    --shard-id - номер шарда
    --no-resync - не обрабатывать очередь ленивой переотправки


=head1 RUNNING

    LOG_TEE=1 ./protected/moderateExportMaster.pl --shard-id 1 --once --cid 263

=cut

use strict;
use warnings;

use ScriptHelper script_timer => undef, get_file_lock => undef, sharded => 1, 'Yandex::Log' => 'messages';
use Yandex::Trace;
use Settings;

use LockTools;
use HashingTools ();
use Yandex::DBTools;

use Moderate::ExportMaster;
use Moderate::Settings;

use utf8;

# время между итерациями, секунд
my $ITERATION_INTERVAL = 30;

my ($ONCE);
my $RESYNC = 1;
extract_script_params(
    'once' => \$ONCE,
    'resync!' => \$RESYNC,
);

my $script = get_script_name();

get_file_lock('dont_die', "$script.lock");

local $Yandex::Advmon::GRAPHITE_PREFIX = sub {[qw/direct_one_min db_configurations/, $Settings::CONFIGURATION]};

Moderate::ExportMaster::init(shard => $SHARD, log => $log);
while(1) {
    my $trace = Yandex::Trace->new(service => 'direct.script', method => 'moderateExportMaster', tags => "shard_$SHARD");

    if (my $reason = smart_check_stop_file()) {
        $log->out("$reason! Let's finish.");
        last;
    }

    my $sql_lock_guard = sql_lock_guard(PPC(shard => $SHARD), $Moderate::Settings::MODERATE_MASTER_LOCK_NAME, 0);

    my $iter_uuid = HashingTools::generate_uuid();
    $log->msg_prefix("[shard_$SHARD,$iter_uuid]");

    $log->out("start iteration");

    my $iter_start_time = time();

    $log->out("Process resync queue");
    Moderate::ExportMaster::process_resync_queue(iter_uuid => $iter_uuid,
                                                   skip_resync => ($RESYNC ? 0 : 1),
                                                   );

    unless ($ONCE) {
        juggler_ok();
    }

    $log->out("iteration end");
    $log->msg_prefix('');
    last if $ONCE;

    my $sleep_interval = $ITERATION_INTERVAL - (time - $iter_start_time);
    if ($sleep_interval > 0) {
        $log->out("Going to sleep for $sleep_interval seconds");
        sleep($sleep_interval);
    }
}

release_file_lock();
