#!/usr/bin/perl

=head1 METADATA

<crontab>
    sharded: 1
    time: 1 11 * * *
    <switchman>
        group: scripts-other
    </switchman>
    package: scripts-switchman
</crontab>
<juggler>
    host:   checks_auto.direct.yandex.ru
    sharded: 1
    ttl:     2d3h
    tag: direct_group_internal_systems
</juggler>


=cut

=head1 DESCRIPTION

    $Id$
    
    Скрипт отправляет повторные уведомления о результате модерации и возможности оплатить кампанию,
        тем у кого кампания принята и до сих пор не оплачена (и при этом не заархивирована).
        
    Автор: Брядов Василий <mirage@yandex-team.ru>

=cut

use warnings;
use strict;

use Yandex::DBTools;
use Yandex::TimeCommon;
use Yandex::ListUtils qw/chunks nsort/;
use List::MoreUtils qw/all/;

use my_inc "..";

use ScriptHelper sharded => 1, 'Yandex::Log' => 'messages';

use Settings;
use User;
use Client;
use Campaign qw/get_camp_info mass_is_universal_campaign/;

use RBAC2::Extended;
use Notification;
use GeoTools qw//;
use TextTools qw/get_num_array_by_str/;

my $cid = '';
extract_script_params(
    "cid=i" => \$cid
);
my $and_cid = $cid ? "AND cid=$cid" : "";

$log->out("start");

my @INTS = (1, 3, 7, 100);

my $rbac = RBAC2::Extended->get_singleton(1);
        
for (my $i = 0; $i <= scalar @INTS; $i++) {
    
    # skip last element
    next if !defined $INTS[$i+1];
    
    my $notifications = get_hashes_hash_sql(PPC(shard => $SHARD), "
                                      SELECT cid, create_time 
                                        FROM warn_pay
                                       WHERE warned_interval <= ? 
                                         AND create_time between date_add(NOW(), INTERVAL -? DAY) and date_add(NOW(), INTERVAL -? DAY) 
                                         $and_cid", $INTS[$i], $INTS[$i+1], $INTS[$i]);
                                         
    for my $cids (chunks [nsort keys %$notifications], 1000) {
        my $campaigns = get_camp_info($cids);
        my $users = get_users_data([map {$_->{uid}} @$campaigns], [qw/statusBlocked ClientID/]);
        my $client_ids = [map {$_->{ClientID}} values %$users];
        my $nirvana_mails_clients = mass_is_new_moderate_send_warn_enabled_for_client($client_ids);
        my $universal_campaign_cids = mass_is_universal_campaign($cids);

        my $camps_groups_geo = get_all_sql(PPC(shard => $SHARD), [
            "select p.cid, b.pid, p.geo, group_concat(distinct bmg.minus_geo) as minus_geo, u.ClientID
            from phrases p 
            left join banners b 
                   on b.pid = p.pid
                  and b.statusShow = 'Yes'
                  and b.statusPostModerate <> 'Rejected'
                  and b.statusArch = 'No'
            left join banners_minus_geo bmg 
                   on bmg.bid = b.bid and bmg.type = 'current'
            join campaigns c on c.cid = p.cid
            join users u on u.uid = c.uid",
            where => {
                'p.cid' => $cids,
            },
            'group by p.cid, b.pid'
        ]);
        
        my %camps_geo;
        for my $geo_row (@$camps_groups_geo) {
            $camps_geo{$geo_row->{cid}}{$geo_row->{pid}}{geo} //= $geo_row->{geo};
            $camps_geo{$geo_row->{cid}}{$geo_row->{pid}}{ClientID} = $geo_row->{ClientID};
            $camps_geo{$geo_row->{cid}}{$geo_row->{pid}}{minus_geo} = $geo_row->{minus_geo};
        }
        for my $cid (keys %camps_geo) {
            for my $pid (keys %{$camps_geo{$cid}}) {
                my $group = $camps_geo{$cid}{$pid};
                my @minus_geo = @{get_num_array_by_str($group->{minus_geo})};
                if (!@minus_geo) {
                    $group->{all_banners_geo_disabled} = 0;
                    next;
                }
                my ($effective_geo, $disabled_geo) = GeoTools::exclude_region($group->{geo}, \@minus_geo, { ClientID => $group->{ClientID} });
                $group->{all_banners_geo_disabled} = $effective_geo eq '';
            }
            $camps_geo{$cid}{all_banners_geo_disabled} = all { $_->{all_banners_geo_disabled} } values %{$camps_geo{$cid}};
        }
        
        my (@cids_to_delete, @cids_to_update);
        foreach my $camp (@$campaigns) {
            # пропускаем клиентов, для которых включена новая отправка писем через Нирвану                        
            next if $nirvana_mails_clients->{$users->{$camp->{uid}}->{ClientID}};
            # все баннеры в кампании отключены по minus_geo
            next if $camps_geo{$camp->{cid}}{all_banners_geo_disabled};
            # универсальная кампания - тоже пропускаем
            next if $universal_campaign_cids->{$camp->{cid}};

            if ((($camp->{wallet_cid} && $camp->{wallet_total} <= 0 && !$camp->{OrderID})
                    || (!$camp->{wallet_cid} && $camp->{sum} <= 0))
                && $camp->{archived} eq 'No'
                && $camp->{type} ne 'geo'
                && $users->{$camp->{uid}}->{statusBlocked} ne 'Yes') {
                    
                $camp->{fio} = delete $camp->{FIO};
                my $notification = $notifications->{$camp->{cid}};
                $camp->{moderate_time} = human_date(mysql2unix($notification->{create_time}));
                add_notification($rbac, 'moderate_send_warn', $camp);
                $log->out("send letter about cid=$camp->{cid}, interval=$INTS[$i+1]");
                
                push @cids_to_update, $camp->{cid};
            } else {
                $log->out("disable letters about cid=$camp->{cid}");
                push @cids_to_delete, $camp->{cid};
            }
        }
        
        if (@cids_to_delete) {
            do_update_table(PPC(shard => $SHARD), 'warn_pay',
                {warned_interval => 100},
                where => {cid => \@cids_to_delete}
            );
        }
        if (@cids_to_update) {
            do_update_table(PPC(shard => $SHARD), 'warn_pay',
                {warned_interval => $INTS[$i+1]},
                where => {cid => \@cids_to_update}
            );
        }
    };
}

juggler_ok();
$log->out("end");
