#!/usr/bin/perl

=head1 METADATA

<crontab>
    time: */5 * * * *
    sharded: 1
    <switchman>
        group: scripts-other
    </switchman>
    package: scripts-switchman
</crontab>

<juggler>
    host:   checks_auto.direct.yandex.ru
    sharded: 1
    ttl: 1h
    tag: direct_group_internal_systems
</juggler>

# <monrun>
#     host:   checks_auto.direct.yandex.ru
#     name: bl_feed_queue.oldest_unupdated_feed
#     warn: 43200
#     crit: 86400
#     expression: 'movingAverage(direct_one_min.db_configurations.production.flow.bl_feed_queue.shard_$shard.performance.Updating.min_secs, "10min")'
#     sharded: 1
# </monrun>

=cut

=head1 NAME

    monitorBLFeedQueueAges.pl - мониторинг очереди обновления performance фида из BannerLand

=head1 DESCRIPTION

    Опции:

    --shard-id - номер шарда для обработки
    --help - справка

=cut


use Direct::Modern;

use Yandex::DBTools;
use Yandex::Advmon;
use Yandex::HashUtils;

use my_inc "..";

use Direct::Model::Feed;
use Settings;

use ScriptHelper sharded => 1, 'Yandex::Log' => 'messages';

extract_script_params();

$log->out('START');

my @feed_types = @{Direct::Model::Feed::FEED_TYPE_VALUES()};
my @update_statuses = @{Direct::Model::Feed::UPDATE_STATUS_VALUES()};

my $feed_statuses = get_all_sql(PPC(shard => $SHARD),
    "SELECT feed_type, update_status,
            MIN(TIMESTAMPDIFF(SECOND, IFNULL(last_refreshed, NOW()), NOW())) as min_secs,
            MAX(TIMESTAMPDIFF(SECOND, IFNULL(last_refreshed, NOW()), NOW())) as max_secs,
            AVG(TIMESTAMPDIFF(SECOND, IFNULL(last_refreshed, NOW()), NOW())) as avg_secs,
            COUNT(*) as count
       FROM feeds
      GROUP BY 1, 2"
);

my @stat_fields = qw/min_secs max_secs avg_secs count/;

my %stat_values;
for my $entry (@$feed_statuses) {
    $stat_values{$entry->{feed_type} // ''}->{$entry->{update_status}} = hash_cut $entry, \@stat_fields;
}

# проставляем умолчания
for my $type (@feed_types) {
    for my $status (@update_statuses) {
        for my $field (@stat_fields) {
            $stat_values{$type}->{$status}->{$field} //= 0;
        }
    }
}

local $Yandex::Advmon::GRAPHITE_PREFIX = sub {[qw/direct_one_min db_configurations/, $Settings::CONFIGURATION]};
Yandex::Advmon::monitor_values({"flow.bl_feed_queue.shard_$SHARD" => \%stat_values});

juggler_ok();

$log->out('FINISH');
